﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>

#include <nn/init.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/os/os_VirtualAddressMemory.h>

#include <nnt.h>

#include "test_VirtualAddressMemoryCommon.h"

// 64bit のみ対応
#if !(defined(NN_OS_CPU_ARM_AARCH64_ARMV8A) || defined(NN_BUILD_CONFIG_CPU_X64))
    #error "This program supports only 64bit architecture."
#endif

//---------------------------------------------------------------------------
//  VirtualAddressMemory 機能のパフォーマンス測定テスト
//---------------------------------------------------------------------------

namespace
{
    const size_t HeapSize = 64 * 1024 * 1024UL;
    uint8_t g_Heap[HeapSize];

    nnt::os::VirtualAddressMemory::CommandProcessor g_Processor;
}

namespace nnt { namespace os { namespace VirtualAddressMemory {

TEST(VirtualAddressMemoryPerformance, AddressRegion)
{
    size_t memorySize = 1024 * 1024 * 1024;
    size_t loopCount = 16;
    size_t minRegionSize = 4 * 1024;
    size_t maxRegionSize = memorySize / loopCount;

    for (size_t regionSize = minRegionSize; regionSize <= maxRegionSize; regionSize *= 2)
    {
        AddressRegionPerformanceTest(regionSize, loopCount);
    }
}

TEST(VirtualAddressMemoryPerformance, MemoryPage)
{
#if defined(NNT_OS_APPLET)
    // Applet region (~450MB) - heap size - usage of other processes on develop (~90MB) - code/data/bss - margin
    size_t regionSize = 256 * 1024 * 1024;
    size_t minPageSize = 4 * 1024;
    size_t maxPageSize = 256 * 1024 * 1024;
#else
    size_t regionSize = 1024 * 1024 * 1024;
    size_t minPageSize = 4 * 1024;
    size_t maxPageSize = 1024 * 1024 * 1024;
#endif

    for (size_t pageSize = minPageSize; pageSize <= maxPageSize; pageSize *= 2)
    {
        MemoryPagePerformanceTest(regionSize, pageSize);
    }
}

}}} // namespace nnt::os::VirtualAddressMemory

extern "C" void nninitStartup()
{
    ::nn::init::InitializeAllocator(reinterpret_cast<void*>(g_Heap), HeapSize);
}
