﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Log.h>
#include <cstdlib>
#include <nn/diag/diag_AbortObserver.h>
#include <nnt/nntest.h>

static const size_t ThreadCount = 90;
static NN_OS_ALIGNAS_THREAD_STACK uint8_t s_Stacks[ThreadCount][4096];
static nn::os::ThreadType s_Threads[ThreadCount];

void DummyThreadFunc(void*)
{
    for (;;)
    {
    }
}

void ThreadStarterFunc(void*)
{
    int startIndex = (nn::os::GetCurrentCoreNumber() - 1) * ThreadCount / 2;
    int endIndex = startIndex + ThreadCount / 2;

    // Thread is signaled -> process switched to TERMINATED state and started to terminate threads
    for (int k = startIndex; k < endIndex; k++)
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(
            nn::os::CreateThread(&s_Threads[k], DummyThreadFunc, 0, s_Stacks[k], sizeof(s_Stacks[k]), nn::os::DefaultThreadPriority, 2));
    }

    // Call NN_ABORT() here to see if we are started too soon.
}

// Prevent SDK abort observers from running IPCs before running svc::Break()
extern "C" void nninitInitializeSdkModule()
{}

extern "C" void nninitFinalizeSdkModule()
{}

TEST(ProcessExit, ProcessExitWithCreateThread)
{
    int64_t delayUs = 50 + nn::os::GetSystemTick().GetInt64Value() % 50; // Use system tick as RNG (but around 80-90 seems nice, but try other values in case timing changes)
    NN_LOG("Will wait for %lld us\n", delayUs);

    nn::os::ThreadType threadStarter[2];
    static NN_OS_ALIGNAS_THREAD_STACK uint8_t s_ThreadStarterStack[2][4096];
    for (int k = 0; k < 2; k++)
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(
            nn::os::CreateThread(&threadStarter[k], ThreadStarterFunc, 0, s_ThreadStarterStack[k], sizeof(s_ThreadStarterStack[k]), nn::os::HighestThreadPriority, 1 + k));
    }

    for (int k = 0; k < 2; k++)
    {
        nn::os::StartThread(&threadStarter[k]);
    }

    nn::os::SleepThread(nn::TimeSpan::FromMicroSeconds(delayUs));

    quick_exit(0);
}
