﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>
#include <nn/nn_Macro.h>
#include <nn/dd.h>


namespace nnt { namespace os { namespace multiWait {

//---------------------------------------------------------------------------

class InterruptGeneratorForHorizon
{
public:
    // コンストラクタ と デストラクタ
    InterruptGeneratorForHorizon()    NN_NOEXCEPT;
    ~InterruptGeneratorForHorizon()   NN_NOEXCEPT;
};

typedef InterruptGeneratorForHorizon    InterruptGenerator;

//---------------------------------------------------------------------------

#if defined( NN_BUILD_CONFIG_HARDWARE_BDSLIMX6 )
const int InterruptNameTest1 = 87;      // Interrupt Number for GPT
const int InterruptNameTest2 = 87;      // Interrupt Number for GPT
const int InterruptNameTest3 = 129;     // Reserved interrupt number
const int InterruptNameTest4 = 129;     // Reserved interrupt number

const int GptPeripheralClock = (132 / 2) * 1000 * 1000;  // 66MHz

// Physical address of GPT register
const nn::dd::PhysicalAddress TimerRegisterPhysicalAddress = 0x02098000;
const size_t                  TimerRegisterRegionSize      = 0x00004000;

#elif defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK1 )

const int InterruptNameTest1 = 32;      // Interrupt Number for TMR1
const int InterruptNameTest2 = 32;      // Interrupt Number for TMR1
const int InterruptNameTest3 = 48;      // Reserved interrupt number (unmapped)

// Physical address of nVIDIA timer register
const nn::dd::PhysicalAddress TimerRegisterPhysicalAddress = 0x60005000;
const size_t                  TimerRegisterRegionSize      = 0x00001000;

#elif defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK2 )

const int InterruptNameTest1 = 32;      // Interrupt Number for TMR1
const int InterruptNameTest2 = 32;      // Interrupt Number for TMR1
const int InterruptNameTest3 = 50;      // Reserved interrupt number (unmapped)

// Physical address of nVIDIA timer register
const nn::dd::PhysicalAddress TimerRegisterPhysicalAddress = 0x60005000;
const size_t                  TimerRegisterRegionSize      = 0x00001000;

#elif defined( NN_BUILD_CONFIG_SOC_TEGRA_X1 )

const int InterruptNameTest1 = 32;      // Interrupt Number for TMR1
const int InterruptNameTest2 = 32;      // Interrupt Number for TMR1
const int InterruptNameTest3 = 50;      // Reserved interrupt number (unmapped)

// Physical address of nVIDIA timer register
const nn::dd::PhysicalAddress TimerRegisterPhysicalAddress = 0x60005000;
const size_t                  TimerRegisterRegionSize      = 0x00001000;

#elif defined( NN_BUILD_CONFIG_HARDWARE_JUNO )

const int InterruptNameTest1 = 198;     // Interrupt Number for TIM01INT
const int InterruptNameTest2 = 198;     // Interrupt Number for TIM01INT
const int InterruptNameTest3 = 176;     // Reserved

// Physical address of SP810 timer register
const nn::dd::PhysicalAddress TimerRegisterPhysicalAddress = 0x1c110000;
const size_t                  TimerRegisterRegionSize      = 0x00010000;

//  SP804 の Timer1 の TIMCLK は SP810 の SP810_CTRL レジスタの
//  TimerEn0Sel ビットの設定によって決まる。
//  デフォルトは 32KHz であり、その設定値をそのまま使う。
const int Sp804Timer1ClockFrequency     = 32 * 1000;    // 32KHz

#elif defined( NN_BUILD_CONFIG_HARDWARE_SMMA53 )

const int InterruptNameTest1 = 34;      // Interrupt Number for TIM01INT
const int InterruptNameTest2 = 34;      // Interrupt Number for TIM01INT
const int InterruptNameTest3 = 50;      // Tied low

// Physical address of SP810 timer register
const nn::dd::PhysicalAddress TimerRegisterPhysicalAddress = 0x1c110000;
const size_t                  TimerRegisterRegionSize      = 0x00010000;

//  SP804 の Timer1 の TIMCLK は SP810 の SP810_CTRL レジスタの
//  TimerEn0Sel ビットの設定によって決まる。
//  デフォルトは 32KHz であり、その設定値をそのまま使う。
const int Sp804Timer1ClockFrequency     = 32 * 1000;    // 32KHz

#else

const nn::dd::PhysicalAddress TimerRegisterPhysicalAddress = 0;
const size_t                  TimerRegisterRegionSize      = 0;

#endif

void ClearTimerInterruptStatus() NN_NOEXCEPT;

//---------------------------------------------------------------------------

}}} // namespace nnt::os::multiWait

