﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../Common/test_Pragma.h"
#include "../Common/test_Helper.h"

#include <nn/nn_Common.h>
#include <nn/nn_SdkText.h>
#include <nn/os.h>

#include <nnt/nntest.h>

namespace nnt { namespace os { namespace memoryFence {

//---------------------------------------------------------------------------
//  メモリフェンス機能のテスト
//  ※）とは言え、実際には API 呼び出しのみ確認を行なう。
//---------------------------------------------------------------------------

TEST(MemoryFenceTest, test_MemoryFenceApiCallTest)
{
    NNT_OS_LOG(NN_TEXT("メモリフェンス API の呼出しが行なえるか"));

    // メモリフェンス API の呼出し確認
    nn::os::FenceMemoryStoreStore();
    nn::os::FenceMemoryStoreLoad();
    nn::os::FenceMemoryStoreAny();
    nn::os::FenceMemoryLoadStore();
    nn::os::FenceMemoryLoadLoad();
    nn::os::FenceMemoryLoadAny();
    nn::os::FenceMemoryAnyStore();
    nn::os::FenceMemoryAnyLoad();
    nn::os::FenceMemoryAnyAny();

    NNT_OS_LOG(" ... OK\n");
    SUCCEED();
}

//---------------------------------------------------------------------------

}}} // namespace nnt::os::memoryFence

