﻿/*---------------------------------------------------------------------------*
  Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Cpu.h>
#include <nn/TargetConfigs/build_Fpu.h>

#if defined NN_BUILD_CONFIG_CPU_ARM64

    .section .text, "ax"
    .align   2
    .global  nntosSetjmpWithFpuContext
    .type    nntosSetjmpWithFpuContext, %function
nntosSetjmpWithFpuContext:
    stp     x19, x20, [x0, #0 * 8]
    stp     x21, x22, [x0, #2 * 8]
    stp     x23, x24, [x0, #4 * 8]
    stp     x25, x26, [x0, #6 * 8]
    stp     x27, x28, [x0, #8 * 8]
    stp     x29, x30, [x0, #10 * 8]
    mov     x1,  sp
    stp     x1,  x2,  [x0, #12 * 8]
    stp     q8,  q9,  [x0, #14 * 8]
    stp     q10, q11, [x0, #18 * 8]
    stp     q12, q13, [x0, #22 * 8]
    stp     q14, q15, [x0, #26 * 8]
    mov     x0, #0
    ret
    .size   nntosSetjmpWithFpuContext, [. - nntosSetjmpWithFpuContext]

    .section .text, "ax"
    .align   2
    .global  nntosLongjmpWithFpuContext
    .type    nntosLongjmpWithFpuContext, %function
nntosLongjmpWithFpuContext:
    ldp     x19, x20, [x0, #0 * 8]
    ldp     x21, x22, [x0, #2 * 8]
    ldp     x23, x24, [x0, #4 * 8]
    ldp     x25, x26, [x0, #6 * 8]
    ldp     x27, x28, [x0, #8 * 8]
    ldp     x29, x30, [x0, #10 * 8]
    ldp     x1,  x2,  [x0, #12 * 8]
    mov     sp, x1
    ldp     q8,  q9,  [x0, #14 * 8]
    ldp     q10, q11, [x0, #18 * 8]
    ldp     q12, q13, [x0, #22 * 8]
    ldp     q14, q15, [x0, #26 * 8]
    mov     x0, #1
    ret
    .size   nntosLongjmpWithFpuContext, [. - nntosLongjmpWithFpuContext]

#else

    .section .text, "ax"
    .align   2
    .global  nntosSetjmpWithFpuContext
    .type    nntosSetjmpWithFpuContext, %function
nntosSetjmpWithFpuContext:
    stmia   r0!, {r4, r5, r6, r7, r8, r9, r10, r11}
    mov     r1, sp
    stmia   r0!, {r1, lr}
    fstmiad r0!, { d8-d15 }
    mov r0, #0
    bx lr
    .size   nntosSetjmpWithFpuContext, [. - nntosSetjmpWithFpuContext]

    .section .text, "ax"
    .align   2
    .global  nntosLongjmpWithFpuContext
    .type    nntosLongjmpWithFpuContext, %function
nntosLongjmpWithFpuContext:
    ldmia   r0!, {r4, r5, r6, r7, r8, r9, r10, r11}
    ldmia   r0!, {r1, lr}
    mov     sp, r1
    fldmiad r0!, { d8-d15 }
    mov r0, #1
    bx lr
    .size   nntosLongjmpWithFpuContext, [. - nntosLongjmpWithFpuContext]

#endif

