﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  キャッシュ操作 API のテスト
//---------------------------------------------------------------------------

#include <cstring>

#include "../Common/test_Pragma.h"
#include "../Common/test_Helper.h"

#include <nn/TargetConfigs/build_Compiler.h>
#include <nn/nn_SdkText.h>

#include <nnt/nntest.h>

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/os.h>
#include <nn/os/os_Cache.private.h>

namespace nnt { namespace os { namespace cacheApi {


const int BufferSize = 8 * 1024 * 1024;
NN_ALIGNAS(4096) char g_Buffer[ BufferSize ];


// API が呼び出せるかどうかのみのテスト
TEST(CacheApi, CallTest)
{
    // 自プロセスのキャッシュ制御
    nn::os::FlushDataCache(g_Buffer, sizeof(g_Buffer) );

    // 全キャッシュフラッシュ
    nn::os::FlushEntireDataCache();
}


// 各API でパフォーマンスを計測
TEST(CacheApi, PerformanceMeasurement)
{
    const int MemoryFillLoopNumber = 10;
    nn::os::Tick startTick;
    nn::os::Tick duration;

    // メモリ書き込みのみ
    startTick = nn::os::GetSystemTick();
    for (int i=0; i<MemoryFillLoopNumber; i++)
    {
        std::memset(g_Buffer, 0x11, sizeof(g_Buffer));
    }
    duration = nn::os::GetSystemTick() - startTick;
    NNT_OS_LOG(NN_TEXT("メモリ書き込みのみの場合 %lld us\n"), nn::os::ConvertToTimeSpan( duration ).GetMicroSeconds());

    // メモリ書き込み + Flush
    startTick = nn::os::GetSystemTick();
    for (int i=0; i<MemoryFillLoopNumber; i++)
    {
        std::memset(g_Buffer, 0x11, sizeof(g_Buffer));
        nn::os::FlushDataCache(g_Buffer, sizeof(g_Buffer));
    }
    duration = nn::os::GetSystemTick() - startTick;
    NNT_OS_LOG(NN_TEXT("メモリ書き込み + Flush の場合 %lld us\n"), nn::os::ConvertToTimeSpan( duration ).GetMicroSeconds());
}

}}} // namespace nnt::os::cacheApi
