﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/omm/omm_Api.h>

void PrintCradleFwVersion()
{
    uint32_t pdcH;
    uint32_t pdcA;
    uint32_t mcu;
    uint32_t dp2hdmi;

    auto result = nn::omm::GetCradleFwVersion(&pdcH, &pdcA, &mcu, &dp2hdmi);
    if( result.IsSuccess() )
    {
        NN_LOG("Cradle Firmware Version : %u, %u, %u, %u.\n", pdcH, pdcA, mcu, dp2hdmi);
    }
    else
    {
        NN_LOG("Unable to get cradle firmware version : 0x%08x\n", result.GetInnerValueForDebug());
    }
}

extern "C" void nnMain()
{
    nn::omm::Initialize();

    nn::os::SystemEvent event;
    nn::omm::GetOperationModeChangeEvent(&event);

    for(;;)
    {
        event.Wait();
        auto mode = nn::omm::GetOperationMode();
        NN_LOG("Operation mode %u\n", mode);
        PrintCradleFwVersion();
    }
}

