﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/base/testBase_Exit.h>

#include <nn/fs.h>
#include <nn/fs/fs_ResultHandler.h>
#include <nn/fs/fs_SystemSaveData.h>
#include <nn/fs/fs_SystemSaveDataPrivate.h>
#include <nn/fs/fs_SaveDataTypes.h>
#include <nn/fs/fs_UserAccountSystemSaveData.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/olsc/olsc_Result.h>
#include <nn/olsc/olsc_ApiForPrivate.h>
#include <nn/olsc/olsc_ApiForSystemService.h>
#include <nn/olsc/olsc_RemoteStorageController.h>
#include <nn/olsc/olsc_TransferTaskListController.h>
#include <nn/olsc/srv/olsc_InternalTypes.h>
#include <nn/olsc/srv/util/olsc_MountManager.h>
#include <nn/olsc/srv/util/olsc_SaveData.h>
#include <nn/os.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_FormatString.h>

#include <nn/account/account_Api.h>
#include <nn/account/account_ApiForSystemServices.h>
#include <nn/account/account_ApiForApplications.h>

using namespace nn;
using namespace nn::olsc;
using namespace nn::olsc::srv;

namespace {

    const int VariationCount = 30;

    account::Uid GetFirstUserId() NN_NOEXCEPT
    {
        int userCount;
        NN_ABORT_UNLESS_RESULT_SUCCESS(account::GetUserCount(&userCount));
        NN_ABORT_UNLESS(userCount > 0);

        account::Uid uid;
        int listCount;
        NN_ABORT_UNLESS_RESULT_SUCCESS(account::ListAllUsers(&listCount, &uid, 1));
        return uid;
    }

    // SaveDataArchiveInfo を偽造
    SaveDataArchiveInfo CreateSaveDataArchive(int appIdOffset) NN_NOEXCEPT
    {
        const Bit64 BaseApplicationId = 0x0005000c10000001ULL;
        SaveDataArchiveInfo ret;
        nn::os::GenerateRandomBytes(&ret.id, sizeof(ret.id));
        ret.nsaId = {0};
        ret.applicationId = { BaseApplicationId + appIdOffset };
        ret.userId = GetFirstUserId();
        ret.deviceId = static_cast<DeviceId>(0x0);
        ret.dataSize = 1024;
        nn::os::GenerateRandomBytes(&ret.seriesInfo.seriesId, sizeof(ret.seriesInfo.seriesId));
        ret.seriesInfo.commitId = 0;
        ret.status = SaveDataArchiveStatus::Uploading;
        ret.autoBackup = false;
        ret.hasThumbnail = false;
        ret.launchRequiredVersion = 0;
        ret.numOfPartitions = 8;
        time::PosixTime time = { 1413263600 };
        ret.savedAt    = time;
        ret.timeoutAt  = time;
        ret.finishedAt = time;
        ret.createdAt  = time;
        ret.createdAt  = time;
        return ret;
    }

    void AddSdaInfoToCache(const account::Uid& uid) NN_NOEXCEPT
    {
        olsc::DeleteAllSaveDataArchiveInfoCache(uid);

        SaveDataArchiveInfo sdaList[VariationCount];
        int applicationIdVariation[VariationCount];
        for(int i = 0; i < VariationCount; i++)
        {
            applicationIdVariation[i] = i;
        }

        for(int i = 0; i < VariationCount; i++)
        {
            sdaList[i] = CreateSaveDataArchive(applicationIdVariation[i]);
            // 順不同で Add
            NNT_ASSERT_RESULT_SUCCESS(olsc::AddSaveDataArchiveInfoCache(uid, sdaList[i]));
        }
    }

}

TEST(OlscRemoteStorageControllerTest, Basic)
{
    NN_LOG("1\n");
    auto uid = GetFirstUserId();
    AddSdaInfoToCache(uid);
    NN_LOG("2\n");
    auto rc = nn::olsc::OpenRemoteStorageController(uid);
    NN_LOG("4\n");

    DataInfo dataInfo[VariationCount];
    int num = rc.ListDataInfo(dataInfo, VariationCount, 0);
    NN_LOG("5\n");
    NN_LOG("num = %d\n", num);
    for(int i = 0; i < num; i++)
    {
        NN_LOG("appId %d : 0x%llx\n", i, dataInfo[i].appId.value);
    }
}

extern "C" void nnMain()
{
    int     argc = nn::os::GetHostArgc();
    char**  argv = nn::os::GetHostArgv();

    account::InitializeForSystemService();
    NN_LOG("0\n");
    ::testing::InitGoogleTest(&argc, argv);

    auto ret = RUN_ALL_TESTS();

    nnt::Exit(ret);
}
