﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/nsd/nsd_ApiForTest.h>
#include "./testNsd_Constant.h"

#include <nn/nsd/nsd_ApiForMiddleware.h>
#include <nn/nsd/nsd_ApiForMenu.h>
#include <nn/nsd/nsd_ApiForNasService.h>
#include <nn/nsd/nsd_ApiForNasServicePrivate.h>

#ifdef NN_BUILD_CONFIG_OS_WIN
#include <nn/fs/fs_ResultHandler.h>
#endif

#include <nn/nn_SdkLog.h>
#if NN_BUILD_CONFIG_OS_WIN

// Windows.h マクロと衝突しないかの確認

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif

#ifndef NOMINMAX
#define NOMINMAX
#endif

#include <nn/nn_Windows.h>

#endif // NN_BUILD_CONFIG_OS_WIN

using namespace nn::nsd;

namespace
{
#ifdef NN_BUILD_CONFIG_OS_WIN
    uint8_t g_WorkBuffer[1024 * 256] = {};
#endif

    SaveData g_SaveData = {};
}

TEST(NsdTest_ForTd1Test, SetTd1EnvironmentForTest)
{
#if defined(NN_BUILD_CONFIG_OS_WIN)
    nn::nsd::SetTd1EnvironmentForTest();
#endif

    //
    // 実機環境では DevMenuCommand で td1 環境をインポート済であることを想定
    //
}

TEST(NsdTest_ForTd1Test, MenuApi)
{
    nn::nsd::EnvironmentIdentifier env;
    nn::nsd::GetEnvironmentIdentifier(&env);
    EXPECT_STREQ("td1", env.value);
}

TEST(NsdTest_ForTd1Test, Resolve)
{
    nn::nsd::Fqdn out;
    NNT_EXPECT_RESULT_SUCCESS(nn::nsd::Resolve(&out, nnt::nsd::constant::Lp1.baasFqdn));
    EXPECT_STREQ(nnt::nsd::constant::Td1.baasFqdn.value, out.value);
}

// Nas Fqdn の直接取得
TEST(NsdTest_ForTd1Test, NasFqdn1)
{
    {
        nn::nsd::Fqdn fqdn;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::GetNasApiFqdn(&fqdn));
        EXPECT_STREQ(nnt::nsd::constant::Td1.nasApiFqdn.value, fqdn.value);
    }
    {
        nn::nsd::Fqdn fqdn;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::GetNasRequestFqdn(&fqdn));
        EXPECT_STREQ(nnt::nsd::constant::Td1.nasRequestFqdn.value, fqdn.value);
    }
}

// Nas Fqdn の Resolve
TEST(NsdTest_ForTd1Test, NasFqdn2)
{
    // dd1 FQDN を入れて td1 FQDN になるか
    // NAS関連は dd1 も変換対象
    {
        nn::nsd::Fqdn out;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::Resolve(&out, nnt::nsd::constant::Dd1.nasApiFqdn));
        EXPECT_STREQ(nnt::nsd::constant::Td1.nasApiFqdn.value, out.value);
    }
    {
        nn::nsd::Fqdn out;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::ResolveEx(&out, nnt::nsd::constant::Dd1.nasRequestFqdn));
        EXPECT_STREQ(nnt::nsd::constant::Td1.nasRequestFqdn.value, out.value);
    }

    // lp1 FQDN を入れて td1 FQDN になるか
    {
        nn::nsd::Fqdn out;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::Resolve(&out, nnt::nsd::constant::Lp1.nasApiFqdn));
        EXPECT_STREQ(nnt::nsd::constant::Td1.nasApiFqdn.value, out.value);
    }
    {
        nn::nsd::Fqdn out;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::ResolveEx(&out, nnt::nsd::constant::Lp1.nasRequestFqdn));
        EXPECT_STREQ(nnt::nsd::constant::Td1.nasRequestFqdn.value, out.value);
    }
}

// NasService の取得
TEST(NsdTest_ForTd1Test, NasService)
{
    // ビルトイン設定を取得して td1 のものと等しいか確認
    {
        nn::nsd::NasServiceSetting setting;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::GetNasServiceSetting(&setting, nn::nsd::NasServiceNameOfNxAccount));
        EXPECT_STREQ(nnt::nsd::constant::Td1.nasServiceSettingOfNxAccount.redirectUri.value, setting.redirectUri.value);
        EXPECT_EQ(nnt::nsd::constant::Td1.nasServiceSettingOfNxAccount.clientId, setting.clientId);
    }
    {
        nn::nsd::NasServiceSetting setting;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::GetNasServiceSetting(&setting, nn::nsd::NasServiceNameOfNxShop));
        EXPECT_STREQ(nnt::nsd::constant::Td1.nasServiceSettingOfNxShop.redirectUri.value, setting.redirectUri.value);
        EXPECT_EQ(nnt::nsd::constant::Td1.nasServiceSettingOfNxShop.clientId, setting.clientId);
    }
    {
        nn::nsd::NasServiceSetting setting;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::GetNasServiceSetting(&setting, nn::nsd::NasServiceNameOfNxFriends));
        EXPECT_STREQ(nnt::nsd::constant::Td1.nasServiceSettingOfNxFriends.redirectUri.value, setting.redirectUri.value);
        EXPECT_EQ(nnt::nsd::constant::Td1.nasServiceSettingOfNxFriends.clientId, setting.clientId);
    }
    {
        nn::nsd::NasServiceSetting setting;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::GetNasServiceSetting(&setting, nn::nsd::NasServiceNameOfNxELicense));
        EXPECT_STREQ(nnt::nsd::constant::Td1.nasServiceSettingOfNxELicense.redirectUri.value, setting.redirectUri.value);
        EXPECT_EQ(nnt::nsd::constant::Td1.nasServiceSettingOfNxELicense.clientId, setting.clientId);
    }
}

TEST(NsdTest_ForTd1Test, DeleteAppSettings)
{
#ifdef NN_BUILD_CONFIG_OS_WIN
    // Windows では直前のテストのためにセーブファイルが存在していないので
    // td1 設定を用意する
    const char Td1Setting[] =
        "eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJTZXR0aW5nTmFtZSI6IlNES-iHquWLleODhuOCueODiCB0ZDEgWzIwMTYtMDktMDYgMDA6MTU6MDggVVRDXSB0ZDEiLCJFbnZpcm9ubWVudCI6InRkMSIsIkJhY2tib25lU2V0dGluZ3MiOnsiTmFzIjp7IlJlcXVlc3RGcWRuIjoiZTAzYTk3ODE5Yzk3MTFlNTk1MTBkODIwYTUyZjI5OGEtc2IuYWNjb3VudHMubmludGVuZG8uY29tIiwiQXBpRnFkbiI6ImUwM2E5NzgxOWM5NzExZTU5NTEwZDgyMGE1MmYyOThhLXNiLWFwaS5hY2NvdW50cy5uaW50ZW5kby5jb20iLCJOeEFjY291bnQiOnsiQ2xpZW50SWQiOjE0NTk4NTkyOTkyMDkwMzI4MTcwLCJSZWRpcmVjdFVyaSI6Im5pbnRlbmRvOi8vYWNjb3VudC5ueC5zeXMifSwiTnhTaG9wIjp7IkNsaWVudElkIjoxMzEyMzg5NDc4OTk5MzM1NTQ2MywiUmVkaXJlY3RVcmkiOiJuaW50ZW5kbzovL3Nob3Aubnguc3lzIn0sIk54RnJpZW5kcyI6eyJDbGllbnRJZCI6NjUxODQ3NjIzODkxMDE3Mzc2MSwiUmVkaXJlY3RVcmkiOiJuaW50ZW5kbzovL2ZyaWVuZHMubnguc3lzIn19LCJGcWRuRW50cmllcyI6W1siZTBkNjdjNTA5ZmIyMDM4NThlYmNiMmZlM2Y4OGMyYWEuYmFhcy5uaW50ZW5kby5jb20iLCJlMDNhOTc4MTljOTcxMWU1OTUxMGQ4MjBhNTJmMjk4YS1zYi5iYWFzLm5pbnRlbmRvLmNvbSJdLFsiZTk3YjhhOWQ2NzJlNGNlNDg0NWVjNjk0N2NkNjZlZjYtc2IuYmFhcy5uaW50ZW5kby5jb20iLCJlMDNhOTc4MTljOTcxMWU1OTUxMGQ4MjBhNTJmMjk4YS1zYi5iYWFzLm5pbnRlbmRvLmNvbSJdXX0sIkFwcGxpY2F0aW9uU2V0dGluZ3MiOnsiRnFkbkVudHJpZXMiOltdfSwiRXhwaXJlIjozMjQ3MjE0NDAwMCwiVmVyc2lvbiI6MSwiRGV2aWNlSWQiOiIwIn0.MLHj47LBCSgXvolBFl5a78tdTfvbwwzRahn7BEBxamk5YqB8nQ6JJSeGtE4rNbcKrAl5naieoXxv2Ch24OFCqpobla77M8qq9vgtQWnXCRZPVs_o5WfZ0mj3pF20C7myRvmB81S47bDNyIGSTENaZdJv9mb2e0CgJ_3S5L1GLFzV1_fBYUcAUeAJ9OJCcNthpgcQKle1LmRM2mdmNCMejTPUSU1VIEi15rJD3x_16B90TI8MJ6ipfXTiHotUEh5k6hN1T3kHJtaBEnhN8ddG7UUp_AB7_m53aw1wAY-MWZ0eMzQFY4i1ESqxo8WAoKd6XdehBK7vZkC_1wj2z_f9UA";
    // テストから fs を使うのでこれを呼んでおく必要がある
    nn::fs::SetResultHandledByApplication(false);

    NNT_ASSERT_RESULT_SUCCESS(nn::nsd::ImportSettings(
        static_cast<const void*>(Td1Setting), sizeof(Td1Setting),
        g_WorkBuffer, sizeof(g_WorkBuffer), nn::nsd::ImportMode_All) );
#endif
    // 保存されている設定が td1 で、削除後は dd1 になるので
    // DeleteMode_ApplicationSettings は一部を0埋めする
    // (DeveleSettings() は void 関数)
    DeleteSettings(nn::nsd::DeleteMode_ApplicationSettings);

    // Application 領域が 0 である確認
    NNT_ASSERT_RESULT_SUCCESS(nn::nsd::ReadSaveDataFromFsForTest(&g_SaveData));
    const char* pSaveData = reinterpret_cast<const char*>( &g_SaveData );
    const size_t fillSize = sizeof(nn::nsd::ApplicationSettings);
    for( int position=0; position < static_cast<int>(fillSize); position++ )
    {
        EXPECT_EQ( *( pSaveData + offsetof(nn::nsd::SaveData, applicationSettings) + position ), 0 );
    }

#ifdef NN_BUILD_CONFIG_OS_WIN
    // Windows ではセーブデータを削除しておく
    DeleteSettings(nn::nsd::DeleteMode_All);
#endif
}
