﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/result/testResult_Assert.h>

#include <nn/ncm/ncm_Service.h>
#include <nn/ncm/ncm_SystemContentMetaId.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/npns.h>
#include <nn/npns/npns_ApiSystem.h>
#include <nn/ns/ns_InitializationApi.h>
#include <nn/ns/ns_Result.h>
#include <nn/ns/ns_VulnerabilityApi.h>
#include <nn/os.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_FormatString.h>

namespace {

    class SystemVersionTest : public testing::Test
    {
    public:
    protected:
        virtual void SetUp()
        {
            nn::ns::Initialize();
        }

        virtual void TearDown()
        {
            nn::ns::Finalize();
        }

        static void SetUpTestCase()
        {
        }

        static void TearDownTestCase()
        {
        }

    };

} // namespace

const nn::ncm::SystemUpdateId SystemUpdateMetaId = { 0x0100000000000816 };

TEST_F(SystemVersionTest, Unit)
{
    // 存在しないメタ
    nn::ns::UpdateSafeSystemVersionForDebug({ 0 }, 0);
    EXPECT_TRUE(nn::ns::NeedsUpdateVulnerability());

    // 存在するけど今入ってるやつよりバージョンが高いメタ
    nn::ns::UpdateSafeSystemVersionForDebug(SystemUpdateMetaId, 0xffffffff);
    EXPECT_TRUE(nn::ns::NeedsUpdateVulnerability());

    // 存在するけど今入ってるやつ以下のバージョンのメタ
    nn::ns::UpdateSafeSystemVersionForDebug(SystemUpdateMetaId, 0);
    EXPECT_FALSE(nn::ns::NeedsUpdateVulnerability());
}
