﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <string>
#include <vector>

#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/nsutil/nsutil_InstallUtils.h>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <nn/fs/fs_Bis.h>

#include <nn/ncm/ncm_Service.h>
#include <nn/ovln/ovln_ForDevelop.h>
#include <nn/ovln/ovln_SenderForOverlay.h>
#include "libraries/testNs_MountHost.h"
#include "testNs_NcmStorageVerify.h"

//#define WILL_CLEAN_SPECIFIED_CONTENTS_AT_BEFORE_TEST

#define LOG_OUT( ... )  NN_LOG( "[NsSystemUpdate] " __VA_ARGS__ )

namespace {

    //!--------------------------------------------------------------------------------------
    //! Case Setup
    //!--------------------------------------------------------------------------------------
    class CupCase : public testing::Test, public nnt::nsutil::ApplicationInstaller
    {
    public:
        static void SetUpTestCase()
        {
            NN_ABORT_UNLESS_RESULT_SUCCESS( testns::MountHostFileSystem( "Contents" ) );
        }

        static void TearDownTestCase()
        {
            testns::UnmountHostFileSystem();
        }

    protected:
        virtual void SetUp()
        {
            nn::ncm::Initialize();

#if defined( NN_BUILD_CONFIG_OS_WIN )
            nn::ovln::PrepareSenderAndReceiverForDevelop();
            NN_ABORT_UNLESS_RESULT_SUCCESS(nn::ovln::InitializeSenderLibraryForOverlay());
#endif

            auto& verifierInstance = nn::util::Get( m_NcmStorageVerifier );
            new ( &verifierInstance ) NcmStorageVerifier( nn::ncm::StorageId::BuildInSystem );
            verifierInstance.Initialize();

            DebugForDeleteContents( verifierInstance );
        }

        virtual void TearDown()
        {
            nn::util::Get( m_NcmStorageVerifier ).Finalize();

#if defined( NN_BUILD_CONFIG_OS_WIN )
            nn::ovln::FinalizeSenderLibraryForOverlay();
            nn::ovln::ReleasePreparedSenderAndReceiverForDevelop();
#endif

            nn::ncm::Finalize();
        }

#if defined( WILL_CLEAN_SPECIFIED_CONTENTS_AT_BEFORE_TEST )
        // ローカルテスト用.
        // 強制的にコンテンツ消すよー
        void DebugForDeleteContents( const NcmStorageVerifier& verifier )
        {
            auto& storageId = verifier.GetStorageId();
            auto& collection = verifier.GetContentMetaKeyCollection();
            for ( auto it = collection.begin(); it != collection.end(); ++it )
            {
                auto& metaKey = *it;
                DeleteAllContents( metaKey.id, storageId );
            }
        }
#else
        void DebugForDeleteContents( const NcmStorageVerifier& verifier )
        {
            // none operated.
            NN_UNUSED( verifier );
        }
#endif // defined( WILL_CLEAN_SPECIFIED_CONTENTS_AT_BEFORE_TEST )

    protected:
        nn::util::TypedStorage< NcmStorageVerifier, sizeof( NcmStorageVerifier ), NN_ALIGNOF( NcmStorageVerifier ) > m_NcmStorageVerifier;
    };
}

TEST_F( CupCase, Simple )
{
    // ストレージ上のインストールコンテンツ及び本体更新対象コンテンツを含むコレクション生成
    auto& verifier = nn::util::Get( m_NcmStorageVerifier );
    verifier.PrepareUnexpectedContentOnStorage();

    // NCMデータベースベリファイ
    verifier.VerifyHasContentOnStorage();
    verifier.VerifyUnnecessaryPlaceHolderOnStorage();
    verifier.VerifyUnexpectedContentOnStorage();

} // NOLINT(impl/function_size)

