﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <nn/nn_Common.h>

namespace testns {

//!--------------------------------------------------------------------------------------
//! @brief 起動コマンド引数の検出、コレクションの初期化
//! @details "--" で始まるキーワードを列挙します。
//! 空白を挟まず "=" で区切られた場合は値としてマッピングされます。
//!--------------------------------------------------------------------------------------
void InitializeCommandLineOptions() NN_NOEXCEPT;

//!--------------------------------------------------------------------------------------
//! @brief 起動コマンド引数コレクションの解放
//!--------------------------------------------------------------------------------------
void FinalizeCommandLineOptions() NN_NOEXCEPT;

//!--------------------------------------------------------------------------------------
//! @brief コマンド引数問い合わせ
//! @return 指定キーが存在した場合は true を返します。
//! @param[in]  pKey            オプションキー文字列( ex: "--testns_Option=Value" の場合、"--testns_Option" が該当します。 )
//! @param[in]  outBufferSize   pMappedValue の格納可能容量( byte )を指定します。
//! @param[out] pMappedValue    指定キーに紐づく値( ex: "--testns_Option=Value" の場合、"Value" が該当します。 )
//!--------------------------------------------------------------------------------------
const bool QueryCommandLineOptions( const char* const pKey, const size_t outBufferSize = 0, char* const pMappedValue = nullptr ) NN_NOEXCEPT;


} // namespace testns
