﻿<#
    $ powershell -Version 2.0 -ExecutionPolicy Unrestricted StopWetherDelivery.ps1
#>

# main 引数
param (
    # Qualify the platforms
    [string] $Platform = "NX-NXFP2-a64",

    # Qualify the build types
    [string] $BuildType = "Develop",

    # Qualify the system update identifier specified.
    [string] $TitleId = "0100000000000816",

    # Qualify the system update version specified.
    [string] $TitleVersion = "65536",

    # Qualify the configuration of delivery id on weather server api.
    [string] $DeliveryId = "18",

    # Qualify the proxy configuration
    [string] $Proxy = "http://proxy.nintendo.co.jp:8080"
)

# スクリプトパス関連 ( 全部文字列型らしい [string] )
$MyScriptPath           = $MyInvocation.MyCommand.Path
$MyScriptDirectoryPath  = [System.IO.Path]::GetDirectoryName($MyScriptPath)

Import-Module "${MyScriptDirectoryPath}\Modules\PlatformUtilities"
Import-Module "${MyScriptDirectoryPath}\Modules\SdkToolUtilities"
Import-Module "${MyScriptDirectoryPath}\Modules\OptionUtilities"

# SDK ROOTパス
$NintendoSdkRootPath = $(Find-NintendoSdkRootPath)

# NintendoSDK Integrate script module インポート
Import-Module "${NintendoSdkRootPath}\Integrate\Scripts\Modules\Error"
Import-Module "${NintendoSdkRootPath}\Integrate\Scripts\Modules\Path"

# -----------------------------------------------------------------------
# HTTP response check.
# -----------------------------------------------------------------------
function Test-HttpResponse( [string]$defResponseStream )
{
    # tee-object で変数格納された response は改行なしで渡される事も想定.
    $defMatchResult = [regex]::Match( ${defResponseStream}, "HTTP\/[0-9]\.[0-9] 200" )
    if ( $defMatchResult.Success -eq $False )
    {
        throw "Failed http request."
    }
}

# ================================
# main
# ================================
try {
    # CIジョブでのTestRunnerは、nact経由でステップ実行し、nactはUTF8で出力を受信している。
    # そのため、強制的にコンソールをUTF-8としている。
    # 但し通常のコード932のDOS窓上では本スクリプトから、Write-Hostなどに日本語指定が使えないので注意。
    $defUseEncoding = New-Object System.Text.UTF8Encoding($False)
    $defBackupConsoleEncoding = [System.Console]::OutputEncoding
    $defBackupEncode = $OutputEncoding
    [System.Console]::OutputEncoding = ${defUseEncoding}
    $OutputEncoding = ${defUseEncoding}

    # エンコード情報表示
    [string] $defConsoleEncode = [System.Console]::OutputEncoding.EncodingName
    [string] $defStartupEncode = $defBackupEncode.EncodingName
    [string] $defCurrentEncode = $OutputEncoding.EncodingName
    Write-Host "[Console]::OutputEncoding : ${defConsoleEncode}"
    Write-Host "Startup `$OutputEncoding   : ${defStartupEncode}"
    Write-Host "Current `$OutputEncoding   : ${defCurrentEncode}"

    # プラットフォームチェック
    $Platform = Resolve-PlatformConstants( ${Platform} )

    Write-Host "Platform        : ${Platform}"
    Write-Host "BuildType       : ${BuildType}"
    Write-Host "SDK Root        : ${NintendoSdkRootPath}"
    Write-Host "ScriptPath      : ${MyScriptPath}"
    Write-Host "ScriptDirectory : ${MyScriptDirectoryPath}"

    # cURL.exe のパス取得
    [string] $defCurlExec = $(Get-CurlExec)

    # プロキシ設定
    [string] $defProxy = $(New-ProxyOption ${Proxy})

    # 配信サーバーAPI ( td1/dev6 )
    [string] $defEnv = "dev6"
    [string] $defRequestUrl = "https://weather.wc.${defEnv}.d4c.nintendo.net/v1/delivery_configurations/${DeliveryId}"

    # CLIトークン取得
    [string] $defTokenJson = $(Get-CliBasicTokenAsJson ${defProxy} ${defEnv})
    [string] $defAccessToken = $(Export-CliTokenFromJson ${defTokenJson} "access_token")
    [string] $defAuthorization = "Authorization: Bearer ${defAccessToken}"

    # 配信設定リクエスト
    [string] $defRequestCommand = "& ${defCurlExec} ${defProxy} --dump-header - -k -H `"${defAuthorization}`" -H `"Content-type: application/json`" -X PUT -d `'{ \`"device_ids\`" : [], \`"title_id\`" : \`"${TitleId}\`", \`"title_version\`" : \`"${TitleVersion}\`" }`' `"${defRequestUrl}`""
    Write-Host "Request command : ${defRequestCommand}"
    ( [string]$defDeliverResponse = Invoke-Expression ${defRequestCommand} )
    $(Test-HttpResponse ${defDeliverResponse})

    # 承認リクエスト
    [string] $defApproveCommand = "& ${defCurlExec} ${defProxy} --dump-header - -k -H `"${defAuthorization}`" -X PUT `"${defRequestUrl}/approve`""
    Write-Host "Approve command : ${defApproveCommand}"
    ( [string]$defApproveResponse = Invoke-Expression ${defApproveCommand} )
    $(Test-HttpResponse ${defApproveResponse})

} catch [Exception] {

    Write-ErrorRecord $_
    $LastExitCode = 1

} finally {

    $OutputEncoding = $defBackupEncode
    [System.Console]::OutputEncoding = $defBackupConsoleEncoding

}
exit $LastExitCode
