﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace CsTestAssistants
{
    /// <summary>
    /// C# 言語仕様に基づくフレームワーク拡張ユーティリティ。
    /// </summary>
    public static class CsExtension
    {
        /// <summary>
        /// 文字列から指定列挙型の値に変換します。
        /// </summary>
        /// <typeparam name="T">列挙型</typeparam>
        /// <param name="name">変換元文字列</param>
        /// <param name="defaultValue">変換できない文字列の場合、返される列挙値。</param>
        /// <returns>変換後の列挙値</returns>
        /// <see cref="System.Enum.TryParse"/>
        public static T ToEnumValue<T>( string name, T defaultValue ) where T : struct
        {
            T outType;
            if ( false == System.Enum.TryParse( name, out outType ) )
            {
                outType = defaultValue;
            }
            return outType;
        }

        /// <summary>
        /// メソッド名とプロパティ名から TestProperty のキーが持つ値を取得します.
        /// </summary>
        /// <remarks>
        /// 拡張APIです.
        /// </remarks>
        /// <param name="instace">参照対象TestProperty属性を保持するメソッドを持つクラスインスタンス</param>
        /// <param name="methodName">参照対象TestProperty属性を保持するメソッド名</param>
        /// <param name="propertyName">参照対象TestProperty属性のName値</param>
        /// <returns></returns>
        public static string GetTestPropertyValue<T>( this T instance, string methodName, string propertyName ) where T : class
        {
            var type = instance.GetType();
            System.Reflection.MethodInfo mi = type.GetMethod( methodName );
            var attributes = mi.GetCustomAttributes( typeof( TestPropertyAttribute ), false );
            if ( null != attributes )
            {
                foreach ( var obj in attributes )
                {
                    var attr = ( TestPropertyAttribute )obj;
                    if ( propertyName.Equals( attr.Name ) )
                    {
                        return attr.Value;
                    }
                }
            }
            return null;
        }
    }
}
