﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        コンテンツ配信のテストを行うための準備をします。
#>

param
(
)

$ErrorActionPreference = 'Stop'

Set-StrictMode -Version Latest

$ScriptPath      = $MyInvocation.MyCommand.Path
$ScriptDirectory = Split-Path $ScriptPath


# --------------------------------------------------------------------------
# 共通モジュール読み込み & 定数定義
# --------------------------------------------------------------------------
Import-Module "$ScriptDirectory\Common"
. "$ScriptDirectory\Constants.ps1"

$TestApplicationV0NspPath = "$IntermediatesDirectory\App_${TestApplicationId}_v0.nsp"
$TestApplicationPatchV0V1NspPath = "$IntermediatesDirectory\Patch_${TestApplicationPatchId}_v0v1.nsp"
$TestApplicationPatchV1V2NspPath = "$IntermediatesDirectory\Patch_${TestApplicationPatchId}_v1v2.nsp"

$TestApplicationSize = 24 * 1024 * 1024

$TestApplicationDescPath = Resolve-Path "$NintendoSdkRootPath\Programs\Iris\Resources\SpecFiles\Application.desc"


# --------------------------------------------------------------------------
# テスト準備 (アプリケーションアップロード編)
# --------------------------------------------------------------------------
# 古い一時ディレクトリを削除
if (Test-Path $IntermediatesDirectory)
{
    Remove-Item $IntermediatesDirectory -Recurse
}
New-Item $IntermediatesDirectory -ItemType Directory | Out-Null

# アプリとパッチを作る
Invoke-MakeTestApplication --id,$TestApplicationId,--unified-version,$TestApplicationV0Version,--size,$TestApplicationSize,--type,Application,--output-file-path,$TestApplicationV0NspPath,--desc,$TestApplicationDescPath,--small-code
Invoke-MakeTestApplication --id,$TestApplicationId,--unified-version,$TestApplicationV1Version,--size,$TestApplicationSize,--type,Patch,--output-file-path,$TestApplicationPatchV0V1NspPath,--desc,$TestApplicationDescPath,--small-code,--original-application,$TestApplicationV0NspPath
Invoke-MakeTestApplication --id,$TestApplicationId,--unified-version,$TestApplicationV2Version,--size,$TestApplicationSize,--type,Patch,--output-file-path,$TestApplicationPatchV1V2NspPath,--desc,$TestApplicationDescPath,--small-code,--original-application,$TestApplicationV0NspPath,--previous-patch,$TestApplicationPatchV0V1NspPath

# 既にアップロード済みの ROM を無効化
Invoke-ContentsUploader revoke-rom,-u,$RopsAuthUserName,-p,$RopsAuthPassword,--application-id,$TestApplicationId,-e,td1

# アップロード
Invoke-ContentsUploader upload,-s,$TestApplicationV0NspPath,-u,$RopsAuthUserName,-p,$RopsAuthPassword,-e,td1,-m,--approve-accept-enabled
Invoke-ContentsUploader upload,-s,$TestApplicationPatchV0V1NspPath,-u,$RopsAuthUserName,-p,$RopsAuthPassword,-e,td1,-m,--approve-accept-enabled,--skip-revoke-enabled
Invoke-ContentsUploader upload,-s,$TestApplicationPatchV1V2NspPath,-u,$RopsAuthUserName,-p,$RopsAuthPassword,-e,td1,-m,--approve-accept-enabled,--skip-revoke-enabled

# 最新版の登録
# v2 はテスト中に登録するため、この時点では v1 を最新にする
Invoke-ContentsUploader register-version,--content-meta-id,$TestApplicationId,--application-id,$TestApplicationId,--type,Application,--content-meta-version,$TestApplicationV0Version,-e,td1
Invoke-ContentsUploader register-version,--content-meta-id,$TestApplicationPatchId,--application-id,$TestApplicationId,--type,Patch,--content-meta-version,$TestApplicationV1Version,-e,td1

# 体験版登録
Invoke-ContentsUploader register-demo,--application-id,$TestApplicationId,-e,td1
