﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/result/testResult_Assert.h>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/util/util_ScopeExit.h>


#include <new>
#include <nn/nifm.h>
#include <nn/ncm/ncm_Service.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/ns/ns_ApplicationVersionSystemApi.h>
#include <nn/ns/ns_InitializationApi.h>
#include <nn/ns/ns_Result.h>

using namespace nn;

namespace
{
    class ApplicationVersionTest : public testing::Test
    {
    public:
    protected:

        static void SetUpTestCase()
        {
        }

        static void TearDownTestCase()
        {
        }

        virtual void SetUp()
        {
            ns::Initialize();
            ClearRequiredVersion();
        }

        virtual void TearDown()
        {
            ClearRequiredVersion();
            ns::Finalize();
        }

    private:

        void ClearRequiredVersion()
        {
            const int MaxEntryCount = 16 * 1024;
            std::unique_ptr<nn::ns::RequiredVersionEntry[]> entryBuffer(new nn::ns::RequiredVersionEntry[MaxEntryCount]);
            ASSERT_TRUE(entryBuffer != nullptr);

            auto out = entryBuffer.get();
            auto outCount = nn::ns::ListRequiredVersion(out, MaxEntryCount);
            for (int i = 0; i < outCount; ++i)
            {
                auto& entry = out[i];
                ncm::ApplicationId id = { entry.id };
                nn::ns::PushLaunchVersion(id, 0);
            }
        }
    };
}


TEST_F(ApplicationVersionTest, GetAndUpgradeRequiredVersion)
{
    ncm::ApplicationId appId = { 1 };

    // 初期値 0
    EXPECT_EQ(0, ns::GetLaunchRequiredVersion(appId));

    const uint32_t MaxVersion = 0xffffffff;
    const uint32_t TestVersion1 = MaxVersion - 1;

    // 最大バージョン - 1 に引き上げ(初回実行の場合は内部的には更新ではなくて追加になっている)
    ns::UpgradeLaunchRequiredVersion(appId, TestVersion1);
    EXPECT_EQ(TestVersion1, ns::GetLaunchRequiredVersion(appId));

    // 引きあげ API でバージョンを下げる方向には調整できない
    ns::UpgradeLaunchRequiredVersion(appId, TestVersion1 - 1);
    EXPECT_EQ(TestVersion1, ns::GetLaunchRequiredVersion(appId));

    // バージョンが記録されている状態から引き上げ API でバージョンを引き上げ(内部的には更新)
    const uint32_t TestVersion2 = TestVersion1 + 1;
    ns::UpgradeLaunchRequiredVersion(appId, TestVersion2);
    EXPECT_EQ(TestVersion2, ns::GetLaunchRequiredVersion(appId));
}
