﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Api.h>
#include <nn/account/account_ApiPrivate.h>
#include <nn/account/account_ApiForAdministrators.h>
#include <nn/account/account_Result.h>
//#include <nn/account/account_ServiceResource.h>

//#include "testAccount_RamFs.h"
//#include "testAccount_Mounter.h"

//#include "testAccount_Util.h"
#include <nn/nn_Log.h>
#include <nn/nn_Common.h>
#include <nn/util/util_ScopeExit.h>

#include <nnt/result/testResult_Assert.h>

namespace nnt { namespace account {

struct UserContext
{
    ::nn::account::Uid          id;
    ::nn::account::UserHandle   open;
    bool                        isOpened;
    bool                        isAdded;

    UserContext() NN_NOEXCEPT : id(::nn::account::InvalidUid), isOpened(false), isAdded(false) {}
    ~UserContext() NN_NOEXCEPT
    {
        Close();
    }

    void Open() NN_NOEXCEPT
    {
        ASSERT_TRUE(static_cast<bool>(id));
        Close();
        NNT_ASSERT_RESULT_SUCCESS(::nn::account::OpenUser(&open, id));
        isOpened = true;
    }

    void Close() NN_NOEXCEPT
    {
        if (isOpened)
        {
            isOpened = false;
            ::nn::account::CloseUser(open);
        }
    }
};

//! コンテキスト生成ユーリティティ
inline void CreateUserContext(UserContext* pUsers, const ::nn::account::Uid* pUids, int count) NN_NOEXCEPT
{
    for (int i = 0; i < count; ++i)
    {
        auto& user = pUsers[i];
        user.id = pUids[i];
        user.isOpened = false;
    }
}

//! アカウント生成ユーリティティ
inline void CreateUsers(UserContext* pUsers, int count, int startCount) NN_NOEXCEPT
{
    nn::account::InitializeForAdministrator();
    NN_UTIL_SCOPE_EXIT
    {
        nn::account::Finalize();
    };
    for (auto i = startCount; i < startCount + count; ++i)
    {
        auto& user = pUsers[i];
        NNT_ASSERT_RESULT_SUCCESS(nn::account::BeginUserRegistration(&user.id));
        NNT_ASSERT_RESULT_SUCCESS(nn::account::CompleteUserRegistration(user.id));
        user.isOpened = false;
        user.isAdded = true;
    }
}

//! 追加したアカウント削除用ユーリティティ
void Cleanup(const UserContext* pUsers) NN_NOEXCEPT;

/*
    ネットワークサービスアカウント周りのユーティリティ
*/
nn::Result RegisterNetworkServiceAccount(nn::account::NetworkServiceAccountAdministrator& admin) NN_NOEXCEPT;
nn::Result UnregisterNetworkServiceAccount(nn::account::NetworkServiceAccountAdministrator& admin) NN_NOEXCEPT;
bool IsNetworkServiceAccountRegistered(nn::account::NetworkServiceAccountAdministrator& admin) NN_NOEXCEPT;

}} // ~namespace nnt::account
