﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/result/testResult_Assert.h>

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>

#include <nn/nifm/nifm_ApiForMenu.h>
#include <nn/nifm/nifm_ApiForTest.h>
#include <nn/nifm/nifm_ApiClientManagement.h>
#include <nn/nifm/nifm_ApiWirelessCommunicationControl.h>
#include <nn/nifm/nifm_ApiInternetConnectionStatus.h>

#include <nn/os/os_ThreadApi.h>

#include "../Common/nifm_TestUtility.h"

namespace
{
    bool g_CheckSeeintgs = false;
    bool g_WifiEnabled = true;
    bool g_AssumedWifiEnabled = true;
}

class PersistentSettingsCaseTest : public ::testing::Test
{
protected:
    static void SetUpTestCase()
    {
        // 本テストプロセスで独占
        nn::nifm::test::SetExclusive<nn::nifm::InitializeAdmin, nn::nifm::FinalizeAdminForTest>(true);
    }

    static void TearDownTestCase()
    {
        // 本テストプロセスで独占解除
        nn::nifm::test::SetExclusive<nn::nifm::InitializeAdmin, nn::nifm::FinalizeAdminForTest>(false);
    }
};


TEST_F(PersistentSettingsCaseTest, CheckWirelessCommunicationEnabled)
{
    NNT_ASSERT_RESULT_SUCCESS(nn::nifm::InitializeAdmin());

    if (g_CheckSeeintgs)
    {
        EXPECT_TRUE(nn::nifm::IsWirelessCommunicationEnabled() == g_AssumedWifiEnabled);
    }
    else
    {
        nn::nifm::SetWirelessCommunicationEnabled(g_WifiEnabled);
        EXPECT_TRUE(nn::nifm::IsWirelessCommunicationEnabled() == g_WifiEnabled);
    }
}


extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);

    for (int i = 0; i < argc; ++i)
    {
        if (std::strcmp(argv[i], "--wifi_on") == 0)
        {
            g_CheckSeeintgs = false;
            g_WifiEnabled = true;
        }
        else if (std::strcmp(argv[i], "--wifi_off") == 0)
        {
            g_CheckSeeintgs = false;
            g_WifiEnabled = false;
        }
        else if (std::strcmp(argv[i], "--wifi_on_assumed") == 0)
        {
            g_CheckSeeintgs = true;
            g_AssumedWifiEnabled = true;
        }
        else if (std::strcmp(argv[i], "--wifi_off_assumed") == 0)
        {
            g_CheckSeeintgs = true;
            g_AssumedWifiEnabled = false;
        }
    }

    auto ret = RUN_ALL_TESTS();

    nnt::Exit(ret);
}
