﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nnt.h>

#include <nn/nifm/nifm_ApiForMenu.h>
#include <nn/nifm/nifm_ApiRequest.h>
#include <nn/nifm/nifm_ApiRequestPrivate.h>

#include "../Common/nifm_TestUtility.h"

namespace
{
    // 利用要求の即座の受理または却下を期待した待ち時間
    const int64_t TIME_OUT_IN_SECONDS_FOR_SUCCESS = 60;
}


TEST(Application, Basic)
{
    nn::nifm::InitializeAdmin();

    nn::nifm::NetworkConnection networkConnection;

    NNT_ASSERT_RESULT_SUCCESS(nn::nifm::SetRequestRawPriority(networkConnection.GetRequestHandle(), 123));
    NNT_ASSERT_RESULT_SUCCESS(nn::nifm::SetRequestPersistent(networkConnection.GetRequestHandle(), true));

    networkConnection.SubmitRequest();

    EXPECT_TRUE(networkConnection.GetSystemEvent().TimedWait(nn::TimeSpan::FromSeconds(TIME_OUT_IN_SECONDS_FOR_SUCCESS)));

    while (NN_STATIC_CONDITION(true))
    {
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(1));

        if (networkConnection.IsAvailable())
        {
            NN_LOG("NetworkConnection is available.\n");
        }
        else
        {
            auto result = networkConnection.GetResult();
            NN_LOG("NetworkConnection is NOT available (%d-%d).\n", result.GetModule(), result.GetDescription());
        }
    }
}

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);

    auto ret = RUN_ALL_TESTS();

    nnt::Exit(ret);
}
