﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/util/util_MathTypes.h>
#include <nn/vi/vi_Layer.h>

/*!
    @brief      文字色の定義です。
 */
struct Color
{
    static const nn::util::Unorm8x4 White;
    static const nn::util::Unorm8x4 Black;
    static const nn::util::Unorm8x4 Gray;
    static const nn::util::Unorm8x4 Green;
    static const nn::util::Unorm8x4 Orange;
    static const nn::util::Unorm8x4 Red;
};

/*!
    @brief      グラフィックス機能を初期化します。
*/
void InitializeGraphicSystem() NN_NOEXCEPT;

/*!
    @brief      グラフィックス機能を終了します。
*/
void FinalizeGraphicSystem() NN_NOEXCEPT;

/*!
    @brief      グラフィックス機能が初期化済みかを判定します。
    @return     初期化済みならば true を返します。
*/
bool IsGraphicSystemInitialized() NN_NOEXCEPT;

/*!
    @brief      文字列の描画を開始します。
*/
void BeginText() NN_NOEXCEPT;

/*!
    @brief      文字列の描画を終了します。
*/
void EndText() NN_NOEXCEPT;

/*!
    @brief      文字列の描画します。
    @param[in]      x                   字数ベースでの x 位置です。
    @param[in]      y                   字数ベースでの y 位置です。
    @param[in]      text                描画する文字列です。
    @param[in]      color               描画する文字色です。
    @param[in]      isFixedWidthEnabled 等幅にするかどうかです。
*/
void WriteText(int x, int y, const char* text, const nn::util::Unorm8x4& color, bool isFixedWidthEnabled) NN_NOEXCEPT;

/*!
    @brief      文字列の描画します。(等幅)
    @param[in]      x               字数ベースでの x 位置です。
    @param[in]      y               字数ベースでの y 位置です。
    @param[in]      text            描画する文字列です。
*/
void WriteTextFixedWidth(int x, int y, const char* text) NN_NOEXCEPT;

/*!
    @brief      文字列の描画します。
    @param[in]      x               字数ベースでの x 位置です。
    @param[in]      y               字数ベースでの y 位置です。
    @param[in]      text            描画する文字列です。
*/
void WriteText(int x, int y, const char* text) NN_NOEXCEPT;

/*!
    @brief      文字列の描画します。
    @param[in]      x               字数ベースでの x 位置です。
    @param[in]      y               字数ベースでの y 位置です。
    @param[in]      text            描画する文字列です。
*/
void WritetErrorText(int x, int y, const char* text) NN_NOEXCEPT;

/*!
    @brief      出画レイヤを取得します。
    @return     出画レイヤを返します。
*/
nn::vi::Layer* GetViLayer() NN_NOEXCEPT;
