@echo off

rem Usage: run_net_ci_ssl.bat <optional_platforms>

if not "%NNTEST_ENABLE_CRL_TEST%"=="true" (
    echo **
    echo ** Warning ** The CRL tests will NOT be ran. Please set NNTEST_ENABLE_CRL_TEST to true and rebuild SSL process and tests.
    echo **
)

nslookup host natf.com > %~dp0\natf_com_ip.txt 2>&1
find "Address:  127.0.0.1" %~dp0\natf_com_ip.txt > nul
if not %ERRORLEVEL% == 0 (
    echo Ssl tests require you to modify your 'hosts' file to include the below entries.
    echo     127.0.0.1    natf.com
    echo     127.0.0.1    natf_2.com
    echo     127.0.0.1    natf_3.com
    echo For windows, you hosts file may be found here:  C:\Windows\System32\drivers\etc\hosts

    del %~dp0\nnatf_com_ip.txt
    goto :OUT
)

nslookup host natf_2.com > %~dp0\natf_com_ip.txt 2>&1
find "Address:  127.0.0.1" %~dp0\natf_com_ip.txt > nul
if not %ERRORLEVEL% == 0 (
    echo Ssl tests require you to modify your 'hosts' file to include the below entries.
    echo     127.0.0.1    natf.com
    echo     127.0.0.1    natf_2.com
    echo     127.0.0.1    natf_3.com
    echo For windows, you hosts file may be found here:  C:\Windows\System32\drivers\etc\hosts

    del %~dp0\nnatf_com_ip.txt
    goto :OUT
)

nslookup host natf_3.com > %~dp0\natf_com_ip.txt 2>&1
find "Address:  127.0.0.1" %~dp0\natf_com_ip.txt > nul
if not %ERRORLEVEL% == 0 (
    echo Ssl tests require you to modify your 'hosts' file to include the below entries.
    echo     127.0.0.1    natf.com
    echo     127.0.0.1    natf_2.com
    echo     127.0.0.1    natf_3.com
    echo For windows, you hosts file may be found here:  C:\Windows\System32\drivers\etc\hosts

    del %~dp0\nnatf_com_ip.txt
    goto :OUT
)

del %~dp0\natf_com_ip.txt

rem Construct platform parameters
if not "%5" == "" (
    set PLATFORMS=%1,%2,%3,%4,%5
) else if not "%4" == "" (
    set PLATFORMS=%1,%2,%3,%4
) else if not "%3" == "" (
    set PLATFORMS=%1,%2,%3
) else if not "%2" == "" (
    set PLATFORMS=%1,%2
) else if not "%1" == "" (
    set PLATFORMS=%1
) else (
    rem Use default parameters
    set PLATFORMS=
)

@setlocal enableextensions enabledelayedexpansion

set SSL_TESTLISTS=

rem Only include NX testlist if NX is included in the platforms
if not "x!PLATFORMS:NX=!"=="x%PLATFORMS%" (
    set SSL_TESTLISTS=%~dp0../../Integrate/Scripts/Testlist/NetworkSslTest-spec.NX.testlist.yml
)

rem Only include Win testlist if Win is included in the platforms
if not "x!PLATFORMS:Win=!"=="x%PLATFORMS%" (
    if not "%SSL_TESTLISTS%"=="" (
        set SSL_TESTLISTS=%SSL_TESTLISTS%,%~dp0../../Integrate/Scripts/Testlist/NetworkSslTest-spec.Win.testlist.yml
    ) else (
        set SSL_TESTLISTS=%~dp0../../Integrate/Scripts/Testlist/NetworkSslTest-spec.Win.testlist.yml
    )
)

rem If no NX or Win platforms were passed, just include both testlists
if "%SSL_TESTLISTS%"=="" (
    set SSL_TESTLISTS=%~dp0../../Integrate/Scripts/Testlist/NetworkSslTest-spec.NX.testlist.yml,%~dp0../../Integrate/Scripts/Testlist/NetworkSslTest-spec.Win.testlist.yml
)

echo TestLists: %SSL_TESTLISTS%

echo %SSL_TESTLISTS% > %~dp0\temp_params.txt

call %~dp0\run_net_param_file.bat %~dp0\temp_params.txt %PLATFORMS%

del %~dp0\temp_params.txt

:OUT
