﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NetTest/Horizon/NetTest_Types.h"
#include "NetTest/Horizon/NetTest_OS.h"
#include "Utils/CommandLineParser.h"

#include <nnt/nntest.h>

#include <windows.h>

namespace
{
    const uint32_t MaxPath = 2 * 1024;
    const uint32_t MaxCmdBufLen = 2 * 1024;
    const char* const AllPidsFile = "AllPids.txt";
}

TEST(natf, RedirectOutput)
{
    char pCmdBuffer[MaxCmdBufLen];
    char pPidsFile[MaxPath];
    char pOutputFile[MaxPath];
    int argC = 0;
    const char * const * pArgV = nullptr;
    NATF::Utils::ParserGroup parser;

    memset(pCmdBuffer, 0, MaxCmdBufLen);
    memset(pPidsFile, 0, MaxPath);
    memset(pOutputFile, 0, MaxPath);

    NETTEST_GET_ARGS(argC, pArgV);

    parser.AddParser(NATF::Utils::StringParser("--Command", nullptr, pCmdBuffer, sizeof(pCmdBuffer)));
    parser.AddParser(NATF::Utils::StringParser("--OutputFile", nullptr, pOutputFile, sizeof(pOutputFile)));
    parser.AddParser(NATF::Utils::StringParser("--PidsFile", "", pPidsFile, sizeof(pPidsFile)));

    if (!parser.Parse(argC, pArgV))
    {
        NN_NETTEST_LOG(" * Failed to parse command line arguements!\n\n");
        FAIL();
        return;
    }

    STARTUPINFOA si;
    PROCESS_INFORMATION pi;
    HANDLE hStdOutput;

    ZeroMemory( &pi, sizeof(pi) );
    ZeroMemory( &si, sizeof(si) );
    si.cb = sizeof(si);
    char windowTitle[] = "NATF";
    si.lpTitle = windowTitle;
    si.dwFlags = STARTF_USESTDHANDLES;

    SECURITY_ATTRIBUTES sa;
    sa.nLength = sizeof(sa);
    sa.lpSecurityDescriptor = NULL;
    sa.bInheritHandle = TRUE;

    HANDLE hFileOut = CreateFileA(pOutputFile, FILE_APPEND_DATA, FILE_SHARE_READ | FILE_SHARE_WRITE, &sa, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
    if( INVALID_HANDLE_VALUE == hFileOut )
    {
        NN_LOG( "Failed to open file: %s.\n\n", pOutputFile);
        FAIL();
        return;
    }

    si.hStdOutput = hFileOut;
    si.hStdError  = hFileOut;

    NN_LOG("Creating new process...\n");

    // Start the child process.
    if( !CreateProcessA( nullptr,    // No module name (use command line)
                         pCmdBuffer, // Command line
                         nullptr,    // Process handle not inheritable
                         nullptr,    // Thread handle not inheritable
                         TRUE,       // Set handle inheritance to TRUE
                         CREATE_NO_WINDOW, // Don't create window
                         nullptr,    // Use parent's environment block
                         nullptr,    // Use parent's starting directory
                         &si,        // Pointer to STARTUPINFO structure
                         &pi ) )     // Pointer to PROCESS_INFORMATION structure
    {
        NN_LOG( "CreateProcess failed (%d).\n\n", GetLastError() );
        FAIL();
    }

    // If pid file name is passed, write pid to file.
    if(pPidsFile[0] != '\0')
    {
        FILE* pFile = fopen(pPidsFile, "at");
        if( !pFile )
        {
            NN_LOG( "Failed to open file: %s. Err: %d\n\n", pPidsFile, ferror(pFile));
            FAIL();
            return;
        }

        fprintf(pFile, "%d\n", pi.dwProcessId);
        fclose(pFile);

        pFile = fopen(AllPidsFile, "at");
        if( !pFile )
        {
            NN_LOG( "Failed to open file: %s. Err: %d\n\n", AllPidsFile, ferror(pFile));
            FAIL();
            return;
        }

        fprintf(pFile, "%d\n", pi.dwProcessId);
        fclose(pFile);
    }

    NN_LOG("Exiting...\n");
}
