﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 Test process for Network
 *---------------------------------------------------------------------------*/

#include "NetTest_Port.h"

#include "Tests/SslAbuseTest.h"
#include "Utils/CommandLineParser.h"

#include <nnt/nntest.h>

// SslAbuse
TEST(natf, SslAbuse)
{
    bool isSuccess;
    NATF::Utils::ParserGroup parser;
    int argc;
    uint16_t defaultPortNum = 443;
    uint16_t portNum = 0;
    uint32_t timeoutMs = 0;
    const char * const * pArgv;

    nn::util::Uuid netProfile;
    char pHostName[NATF::Tests::SslAbuse::MaxHostNameLen];
    char pTestName[NATF::BaseTest::NameBufferLen];
    char pServerCertPath[NATF::Tests::SslAbuse::PathBufLen];

    NN_NETTEST_LOG("\nEnter NATF Process\n\n");

    NETTEST_GET_ARGS(argc, pArgv);

    parser.AddParser(NATF::Utils::StringParser ("--Name", nullptr, pTestName, sizeof(pTestName)));
    parser.AddParser(NATF::Utils::UuidParser   ("--NetProfile", &nn::util::InvalidUuid, netProfile));
    parser.AddParser(NATF::Utils::StringParser ("--HostName", nullptr, pHostName, sizeof(pHostName)));
    parser.AddParser(NATF::Utils::UInt16Parser ("--PortNum", &defaultPortNum, portNum));
    parser.AddParser(NATF::Utils::UInt32Parser ("--TimeoutMs", nullptr, timeoutMs));
    parser.AddParser(NATF::Utils::StringParser ("--ServerCertPath", nullptr, pServerCertPath, sizeof(pServerCertPath)));

    if( !parser.Parse(argc, pArgv) )
    {
        NN_NETTEST_LOG(" * Failed to parse command line arguements!\n\n");
        EXPECT_EQ(false, true);
        return;
    }

    NATF::Tests::SslAbuse sslAbuse(pTestName, netProfile, timeoutMs, pHostName, portNum, pServerCertPath);

    isSuccess = sslAbuse.Run();
    EXPECT_EQ(isSuccess, true);

    NN_NETTEST_LOG("\nExit NATF Process\n\n");
}
