﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <nn\os.h>
#include <stdint.h>
namespace nnt { namespace net { namespace manualtests { namespace utils {

    class ThreadManager
    {
    public:
        enum ThreadStatus : uint8_t
        {
            ThreadStatus_Empty = 0,
            ThreadStatus_Created = 1,
            ThreadStatus_Running = 2,
            ThreadStatus_Stopping = 3,
            ThreadStatus_Stopped = 4,
            ThreadStatus_Error = 5,
            ThreadStatus_Success = 6,
        };
        static const uint32_t MaxThreads = 32;
    private:
        static const uint32_t ThreadStackSize = 32 * 1024;
        NN_OS_ALIGNAS_THREAD_STACK uint8_t m_ThreadStacks[MaxThreads][ThreadStackSize];
        nn::os::ThreadType m_Threads[MaxThreads];
        nn::os::MutexType m_ThreadManagerMutex;
        nn::os::MutexType m_ThreadMutexes[MaxThreads];
        ThreadStatus m_ThreadStatuses[MaxThreads];
        uint32_t m_CurrentThreadCount;

        int32_t GetThreadIndex(nn::os::ThreadType * pThreadType);


    public:

        ThreadManager();
        ~ThreadManager();
        nn::os::ThreadType * CreateThread(void(*pThreadFunc) (void *), void * pThreadFuncArg, int priority = nn::os::DefaultThreadPriority);
        int DestroyThread(nn::os::ThreadType * pThreadType);
        int WaitThreadWithTimeout(nn::os::ThreadType * pThreadType, nn::TimeSpan timeout);
        int WaitThreadsWithTimeout(nn::os::ThreadType ** pThreadTypes, int threadCount, nn::TimeSpan timeout);
        int WaitAllThreadsWithTimeout(nn::TimeSpan timeout);
        int DestroyThreadWithTimeout(nn::os::ThreadType * pThreadType, nn::TimeSpan timeout);
        int StartThread(nn::os::ThreadType * pThreadType);
        int StartAllThreads();
        int StartAllThreadsStaggered(nn::TimeSpan staggerDelay);
        int GetThreadStatus(nn::os::ThreadType * pThreadType, ThreadStatus * pThreadStatus);
        int SetThreadStatus(nn::os::ThreadType * pThreadType, ThreadStatus threadStatus);
        int SetCurrentThreadStatus(ThreadStatus threadStatus);
        int GetCurrentThreadStatus(ThreadStatus * pThreadStatus);

    };

}}}}
