﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

////////////////////////////////////////////////////////////////
// DEFAULT: DISABLED

//#define ENABLE_FAILING_TESTS

#include <nn/socket.h>
#include <nn/nn_Log.h>

#include "testNet_ApiCommon.h"
#include "Unit/testNet_ApiUnitCommon.h"

namespace
{
    bool TestInetHtonl_HostLong(uint32_t hostAddr, bool isSupported)
    {
        bool isSuccess = true;
        uint32_t rval;

        PRINT_AND_CALL(rval = nn::socket::InetHtonl(hostAddr));

        if( isSupported )
        {
            ERROR_IF(!NATF::API::VerifyHostNetAddrEquiv(hostAddr, rval), "InetHtonl failed when expected to succeed.");
        }
        else
        {
            ERROR_IF(NATF::API::VerifyHostNetAddrEquiv(hostAddr, rval), "InetHtonl succeeded when expected to fail.");
        }

out:
        return isSuccess;
    }

    bool TestInetHtonl_Main()
    {
        bool isSuccess = true;
        bool rval = false;

        ////////////////////////////////////////////////////////////////
        // Function:
        // uint32_t htonl(uint32_t hostlong);

        ////////////////////////////////////////////////////////////////
        // Argument:
        // uint32_t hostlong

        PRINT_AND_CALL(rval = TestInetHtonl_HostLong(0x00000000, true));
        ERROR_IF_AND_COUNT(rval != true, "InetHtonl() test failed");

        PRINT_AND_CALL(rval = TestInetHtonl_HostLong(0xFF000000, true));
        ERROR_IF_AND_COUNT(rval != true, "InetHtonl() test failed");

        PRINT_AND_CALL(rval = TestInetHtonl_HostLong(0x00FF0000, true));
        ERROR_IF_AND_COUNT(rval != true, "InetHtonl() test failed");

        PRINT_AND_CALL(rval = TestInetHtonl_HostLong(0x0000FF00, true));
        ERROR_IF_AND_COUNT(rval != true, "InetHtonl() test failed");

        PRINT_AND_CALL(rval = TestInetHtonl_HostLong(0x000000FF, true));
        ERROR_IF_AND_COUNT(rval != true, "InetHtonl() test failed");

        PRINT_AND_CALL(rval = TestInetHtonl_HostLong(0xFFFFFFFF, true));
        ERROR_IF_AND_COUNT(rval != true, "InetHtonl() test failed");

        PRINT_AND_CALL(rval = TestInetHtonl_HostLong(static_cast<uint32_t>(-1), true));
        ERROR_IF_AND_COUNT(rval != true, "InetHtonl() test failed");

out:
        return isSuccess;
    }

} // unnamed

namespace NATF {
namespace API {

TEST(ApiUnit, TestInetHtonl_Setup)
{
    bool isSuccess = true;
    NN_LOG("In\n\n");

    ERROR_IF(!NATF::API::TestSetup(NATF::API::TestSetupOptions_Socket), "TestSetup failed");

out:
    EXPECT_EQ(isSuccess, true);
    NN_LOG("Out\n\n");
}

TEST(ApiUnit, TestInetHtonl_Main)
{
    bool isSuccess = true;
    NN_LOG("In\n\n");

    INITIALIZE_TEST_COUNTS;

    NN_LOG("Calling TestInetHtonl_Main...\n");
    isSuccess = ::TestInetHtonl_Main();

    PRINT_TEST_COUNTS;

    EXPECT_EQ(isSuccess, true);
    NN_LOG("Out\n\n");
}

TEST(ApiUnit, TestInetHtonl_Teardown)
{
    bool isSuccess = true;
    NN_LOG("In\n\n");

    ERROR_IF(!NATF::API::TestTeardown(), "TestTeardown failed");

out:
    EXPECT_EQ(isSuccess, true);
    NN_LOG("Out\n\n");
}

}} // NATF::API
