﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//////////////////////////////////////////////////////////////
// DEFAULT: DISABLED
//
// #define ENABLE_FAILING_TESTS
//


//////////////////////////////////////////////////////////////
// DEFAULT: ENABLE_LONG_RUNNING_DNS_PARSE_TESTS - DISABLED
//
// #define ENABLE_LONG_RUNNING_DNS_PARSE_TESTS

#include <iostream>
#include <string>
#include <regex>

#include <nn/os.h>
#include <nn/nn_Log.h>
#include <nn/socket.h>
#include <nnt/nntest.h>
#include <nn/os/os_Thread.h>

#include <cstdio>   // sprintf
#include <cctype>   // isprint

#include "testNet_ApiCommon.h"
#include "Unit/testNet_ApiUnitCommon.h"

#include "Unit/testNet_ThreadedTest.h"          // Threads for testing
#include "Unit/testNet_LoopbackDnsServer.h"     // Loopback DNS

#include <nn/socket/socket_ApiPrivate.h>

#ifndef NN_BUILD_CONFIG_OS_WIN32
#include <nn/socket/resolver/resolver_Client.h>
#endif

namespace NATF {
namespace API {

//*********************
//*  G L O B A L S
//*********************

char    g_gniHost[nn::socket::Ni_MaxHost], g_gniService[nn::socket::Ni_MaxServ];


static bool
InitializeTesting()
{
    nn::Result                result;
    bool                      isSuccess = true;

    NN_LOG( "In\n\n" );

    ///////////////////////////
    //// Test Counts: Initialize
    ///////////////////////////

    INITIALIZE_TEST_COUNTS;


    ///////////////////////////
    //// NIFM Library: Initialize
    ///////////////////////////

    ERROR_IF(!NATF::API::TestSetup(NATF::API::TestSetupOptions_Nifm | NATF::API::TestSetupOptions_Socket), "TestSetup failed.");

    // NIFM: Network Interface is Online
    NN_LOG( "====================================\n" );
    NN_LOG( "NIFM: Network ===>  O N L I N E <===\n" );
    NN_LOG( "====================================\n" );

    return( true );

out:

    return( false );
}


static bool
TeardownTesting()
{
     bool    isSuccess = true;


    ////////////////////
    ////  Stop Testing
    ////////////////////

    ERROR_IF(!NATF::API::TestTeardown(), "TestTeardown failed.");

out:

    ////////////////////
    ////  Print Test Counts
    ////////////////////

    PRINT_TEST_COUNTS;

    EXPECT_EQ( isSuccess, true );

    NN_LOG( "Out\n\n" );

    return( true );
}


static bool
MakeSockAddr( nn::socket::SockAddr * sa, uint16_t port, const char * domainname, nn::socket::Family family )
{
    nn::socket::SockAddrIn *  sin;
    int                   rc;
    bool                  isSuccess = true;

    sin = (nn::socket::SockAddrIn *) sa;
    sin->sin_family = family;
    sin->sin_port   = nn::socket::InetHtons( port );

    rc = nn::socket::InetPton( nn::socket::Family::Af_Inet, domainname, &(sin->sin_addr) );
    ERROR_IF(  rc != 1, "GNI InetPton failed to convert IP Address !" );

    return( true );

out:

    return( false );
}


static bool
CallGetNameInfo( const nn::socket::SockAddr * sa, nn::socket::SockLenT saLen, char * rtrnHost, size_t hostLen,
                 char * rtrnService, size_t serviceLen, nn::socket::NameInfoFlag flags )
{
    nn::socket::AiErrno rc = nn::socket::AiErrno::EAi_Success;

    // Initialize Return Values
    if ( rtrnHost != NULL )
    {
        memset( rtrnHost, 0, hostLen );
    }

    if ( rtrnService != NULL )
    {
        memset( rtrnService, 0, serviceLen );
    }

    // Call GetNameInfo()
    rc = nn::socket::GetNameInfo( sa, saLen, rtrnHost, (nn::socket::SockLenT) hostLen, rtrnService, (nn::socket::SockLenT) serviceLen, flags );
    if ( rc == nn::socket::AiErrno::EAi_Success )
    {
        NN_LOG( "GNI: Good return Code, Returned, rc: %d\n", rc );
        NN_LOG( "Rtrn Host    : %s\n", rtrnHost );
        NN_LOG( "Rtrn Service : %s\n", rtrnService );

         // Fall thru
    }
    else
    {
        NN_LOG( "nn::socket::CallGetNameInfo() Failed with: rc: %d, errno: %d, h_errno: %d, hstrerror: %s\n",
                                 rc,
                 nn::socket::GetLastError(), *(nn::socket::GetHError() ),
                 nn::socket::HStrError(  *(nn::socket::GetHError() ) ) );
        goto out;
    }

    // Good return code
    return( true );

out:

    return( false );
}

TEST(ApiUnit,Win_GetNameInfo_Initialize)
{
    InitializeTesting();
}

typedef struct {

    const char *                desc;
    nn::socket::Family          family;
    int                         port;
    const char *                dottedIP;
    bool                        result;
    int                         syserrno;
    nn::socket::NameInfoFlag    flags;
    const char *                regex1;
    const char *                regex2;
} GNI_ArgumentResult;


// Anonymous Name Space
namespace {


static GNI_ArgumentResult    g_myArgumentResults[] =
{

    /* description                                                                        */
    /* Family   Port       IP Address (ASCII)   Result       Syserrno   Flags             */
    /* regex1   regex2                                                                    */


    { "Call GNI for: [E-ROOT USC + Flags: NULL] IPv4",
      nn::socket::Family::Af_Inet,    80,      "192.203.230.10",     true,          0,       nn::socket::NameInfoFlag::Ni_None,
      "e.root-servers.net", "http",  },

    { "Call GNI for: [E-ROOT USC + Flags: nn::socket::NameInfoFlag::Ni_NameReqd | nn::socket::NameInfoFlag::Ni_Dgram][/bin/login] IPv4",
      nn::socket::Family::Af_Inet,   513,      "192.203.230.10",     true,          0,       nn::socket::NameInfoFlag::Ni_NameReqd,
      "e.root-servers.net", "login" },

    { "Call GNI for: [E-ROOT USC + Flags: nn::socket::NameInfoFlag::Ni_NameReqd | nn::socket::NameInfoFlag::Ni_Dgram][WHOIS] IPv4",
      nn::socket::Family::Af_Inet,   513,      "192.203.230.10",     true,          0,       nn::socket::NameInfoFlag::Ni_NameReqd | nn::socket::NameInfoFlag::Ni_Dgram,
      "e.root-servers.net", "who" },

    { "Call GNI for: [E-ROOT USC + Flags: nn::socket::NameInfoFlag::Ni_NoFqdn][HTTPS] IPv4",
      nn::socket::Family::Af_Inet,   443,      "192.203.230.10",     true,          0,       nn::socket::NameInfoFlag::Ni_NoFqdn,
      "e", "https" },

    { "Call GNI for: [E-ROOT USC + Flags: nn::socket::NameInfoFlag::Ni_NumericHost][HTTPS] IPv4",
      nn::socket::Family::Af_Inet,   443,      "192.203.230.10",     true,          0,       nn::socket::NameInfoFlag::Ni_NumericHost,
      "192.203.230.10", "https" },

    { "Call GNI for: [E-ROOT USC + Flags: nn::socket::NameInfoFlag::Ni_NumericServ][HTTPS] IPv4",
      nn::socket::Family::Af_Inet,   443,      "192.203.230.10",     true,          0,       nn::socket::NameInfoFlag::Ni_NumericServ,
      "e.root-servers.net", "443" },

    { "Call GNI for: [E-ROOT USC + Flags: nn::socket::NameInfoFlag::Ni_NumericServ | nn::socket::NameInfoFlag::Ni_NumericHost][HTTPS] IPv4",
      nn::socket::Family::Af_Inet,   443,      "192.203.230.10",     true,          0,       nn::socket::NameInfoFlag::Ni_NumericServ | nn::socket::NameInfoFlag::Ni_NumericHost,
      "192.203.230.10",  "443" },

    { "Call GNI for: [192.203.230.10 + Flags: (ALL) ][HTTPS] IPv4",
      nn::socket::Family::Af_Inet,   443,      "192.203.230.10",      true,         0,
      nn::socket::NameInfoFlag::Ni_NoFqdn | nn::socket::NameInfoFlag::Ni_NumericHost | nn::socket::NameInfoFlag::Ni_NameReqd | nn::socket::NameInfoFlag::Ni_NumericServ | nn::socket::NameInfoFlag::Ni_Dgram,
      0, 0 },

    { "Call GNI for: [127.0.0.1 + Flags: nn::socket::NameInfoFlag::Ni_NameReqd][HTTPS] IPv4",
      nn::socket::Family::Af_Inet,   443,      "127.0.0.1",    true,         0,             nn::socket::NameInfoFlag::Ni_NameReqd,
      0, 0 }
};


} // Anonymous namespace


TEST(ApiUnit,Win_GetNameInfo_Argument_Results)
{
    nn::socket::SockAddr     sa;
    unsigned int        idx;
    bool                rval, isSuccess = false, keepgoing = true;

    size_t myResultSize = sizeof( g_myArgumentResults ) / sizeof( GNI_ArgumentResult  );

    for( idx = 0; idx < myResultSize; idx++ )
    {
        NN_LOG( "Test Description:  %s\n", g_myArgumentResults[idx].desc );
        NN_LOG( "Inputs: Address Family: %d, Dotted IP Address: %s, Result: %s, flags: 0x%x, syserrno: %d, regex1: %s,  regex2: %s\n",
        g_myArgumentResults[idx].family, g_myArgumentResults[idx].dottedIP,
        ( g_myArgumentResults[idx].result == true ? "true" : "false" ), g_myArgumentResults[idx].flags,
        g_myArgumentResults[idx].syserrno, g_myArgumentResults[idx].regex1, g_myArgumentResults[idx].regex2  );

        // Make Socket Addr
        rval = MakeSockAddr( &sa, (uint16_t) g_myArgumentResults[idx].port, g_myArgumentResults[idx].dottedIP, g_myArgumentResults[idx].family );
        ERROR_IF( rval == false, "GNI - Failed calling MakeSockAddr()\n" );

        // GetNameInfo()
        rval = CallGetNameInfo( &sa, sizeof( sa ), g_gniHost, sizeof( g_gniHost), g_gniService, sizeof( g_gniService ), g_myArgumentResults[idx].flags );

        if ( g_myArgumentResults[idx].result == true )
        {
            if ( rval != true )
            {
                NN_LOG( "Return Code Failed, but should have Succeeded.  Errno=<%d>\n", nn::socket::GetLastError() );
                ERROR_IF_AND_COUNT( keepgoing == true, "Stopping Test" );
            }
        }
        else
        {
            if ( rval == true )
            {
                ERROR_IF_AND_COUNT( keepgoing == true, "Return Code is Success, but should have Failed!\n" );
                ERROR_IF_AND_COUNT( keepgoing == true, "Stopping Test" );
            }
        }

        // If Regular Expression 1 is present..
        if ( g_myArgumentResults[idx].regex1 != NULL )
        {
            // Construct a Regular Expression
            std::regex myRegex( g_myArgumentResults[idx].regex1 );

            if ( std::regex_match( g_gniHost, myRegex ) )
            {
                NN_LOG( "====> REGEX1 PASSED <==== for Host: %s\n", g_gniHost );
                // Fall Thru
            }
            else if ( std::regex_match( g_gniService, myRegex ) )
            {
                NN_LOG( "====> REGEX1 PASSED <==== for Service: %s\n", g_gniService );
                // Fall Thru
            }
            else
            {
                 NN_LOG( "=====> Failed to REGEX1 pattern match: %s to either host: %s, or service: %s\n",
                         g_myArgumentResults[idx].regex1, g_gniHost, g_gniService );

                 goto out;

            }
        }

        // If Regular Expression 2 is present..
        if ( g_myArgumentResults[idx].regex2 != NULL )
        {
            // Construct a Regular Expression
            std::regex myRegex( g_myArgumentResults[idx].regex2 );

            if ( std::regex_match( g_gniHost, myRegex ) )
            {
                NN_LOG( "====> REGEX2 PASSED <==== for Host: %s\n", g_gniHost );
                // Fall Thru
            }
            else if ( std::regex_match( g_gniService, myRegex ) )
            {
                NN_LOG( "====> REGEX2 PASSED <==== for Service: %s\n", g_gniService );
                // Fall Thru
            }
            else
            {
                NN_LOG( "=====> Failed to REGEX2 pattern match: %s to either host: %s, or service: %s\n",
                        g_myArgumentResults[idx].regex2, g_gniHost, g_gniService );

                goto out;
             }
        }
        ERROR_IF_AND_COUNT( keepgoing == false, "No Op" );
    }


out:

    return;

}  // NOLINT(impl/function_size)


TEST(ApiUnit,Win_GetNameInfo_Teardown)
{
    TeardownTesting();
}

}}  // Namespace: NATF::API
