﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Log.h>
#include <nn/socket.h>
#include <nnt/nntest.h>

#include "Complex/testNet_SelectUnitNetworkCommon.h"

namespace NATF {
namespace API {

NN_ALIGNAS(4096) uint8_t g_ErrnoMemoryPoolBuffer[nn::socket::DefaultSocketMemoryPoolSize];

TEST(ApiUnit,Errno_GetLastErrno)
{
    nn::Result  result;
    int         retcd;

    result = nn::socket::Initialize(g_ErrnoMemoryPoolBuffer,
                                nn::socket::DefaultSocketMemoryPoolSize,
                                nn::socket::MinSocketAllocatorSize,
                                nn::socket::DefaultConcurrencyLimit);
    if( result.IsFailure() )
    {
        NN_LOG("Error: nn::socket::Initialize() failed. Err Desc: %d\n", result.GetDescription());
        ADD_FAILURE();
        goto bail;
    }

    // Make a system call to fnctl() that will fail
    retcd = nn::socket::Fcntl( -1, nn::socket::FcntlCommand::F_SetFl, nn::socket::FcntlFlag::O_NonBlock );
    if ( 0 == retcd )
    {
        NN_LOG("Error: Fcntl returned (0) -- but requested socket descriptor is (-1)\n" );
        ADD_FAILURE();
        goto bail;
    }

    NN_LOG( "Fcntl(): Sucessfullly (FAILED) like it was supposed to...\n" );

    if ( nn::socket::GetLastError() != nn::socket::Errno::EBadf )
    {
        NN_LOG("Error: nn::socket::GetLastError (IS NOT) nn::socket::Errno::EBadf, it is <%ld>\n", nn::socket::GetLastError() );
        ADD_FAILURE();
        goto bail;
    }

    NN_LOG( " nn::socket::GetLastError() result is: nn::socket::Errno::EBadf.  This is ccorrect!\n" );

bail:

    ;

    // Nothing to do
};


TEST(ApiUnit,Errno_SetLastErrno)
{
    nn::Result          result;
    nn::socket::Errno   error = nn::socket::Errno::ESuccess;

    // I can set ERRNO to (ZERO == 0)
    NN_LOG("Forcing ERRNO to (ZERO == 0)\n" );
    nn::socket::SetLastError(nn::socket::Errno::ESuccess);      // void

    // Get internal API value of Errno
    error =  nn::socket::GetLastError();
    if ( nn::socket::Errno::ESuccess != error )
    {
        NN_LOG("Error: nn::socket::SetLastError() was set to (ZERO == 0), but actually returned (%ld)\n", error );
        ADD_FAILURE();
        goto bail;
    }

    NN_LOG("ERRNO is (ZERO == 0)\n" );

    // Make a system call to fnctl() that will fail - this populates (ERRNO) with nn::socket::Errno::EBadf
    NN_LOG("Issuing (BAD) Fcntl() function call to populate (ERRNO == nn::socket::Errno::EBadf)\n" );
    nn::socket::Fcntl( -1, nn::socket::FcntlCommand::F_SetFl, nn::socket::FcntlFlag::O_NonBlock );

    // I can set ERRNO to (ZERO == 0)
    NN_LOG("Forcing ERRNO to (ZERO == 0)\n" );
    nn::socket::SetLastError(nn::socket::Errno::ESuccess);      // void

    // Get internal API value of Errno
    error =  nn::socket::GetLastError();
    if ( nn::socket::Errno::ESuccess != error )
    {
        NN_LOG("Error: nn::socket::SetLastError() was set to (nn::socket::Errno::ESuccess == 0), but actually returned (%ld)\n", error );
        ADD_FAILURE();
        goto bail;
    }

    NN_LOG("ERRNO is (ZERO == 0)\n" );

bail:

    ;

};

} // namespace NATF
} // namespace API
