﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Tests/IoctlLoopbackTest.h"

namespace NATF {
namespace Tests {

    // Constructor
    IoctlLoopback::IoctlLoopback() NN_NOEXCEPT
        :
        BaseTest("IoctlLoopback", false, Utils::InitApiFlags::InitApiFlags_Socket),
        server(Modules::IoctlModule::AppType_Server, "127.0.0.1", 8002, Modules::IoctlModule::InitType_Socket),
        client(Modules::IoctlModule::AppType_Client, "127.0.0.1", 8002, Modules::IoctlModule::InitType_Socket)
    { }

    // Destructor
    IoctlLoopback::~IoctlLoopback() NN_NOEXCEPT {}

    // Config
    bool IoctlLoopback::Config() NN_NOEXCEPT
    {
        TestThread* pThread1 = CreateTestThread("Thread_1", 300);
        if( !pThread1 )
        {
            return false;
        }

        pThread1->AddModule(server);

        TestThread* pThread2 = CreateTestThread("Thread_2", 200);
        if( !pThread2 )
        {
            return false;
        }

        pThread2->AddModule(client);

        return true;
    }

} // namespace Tests
} // namespace NATF
