#!/bin/bash

if [ "$1" == "" ]
then
    echo "**"
    echo "** Error: Please pass chain index"
    echo "** Example:" $0 "1"
    echo "**"
    sleep 3
    exit -1
fi

# Make Chain folder
mkdir Chain_$1
RESULT=$?
if [ $RESULT != 0 ]
then
   echo
   echo " * Failed to make directory" Chain_$1 "Error:" $RESULT
   exit $RESULT
fi

cd Chain_$1
RESULT=$?
if [ $RESULT != 0 ]
then
   echo
   echo " * Error: " $RESULT
   exit $RESULT
fi

# Create root key
openssl genrsa -out root_key.pem 2048
RESULT=$?
if [ $RESULT != 0 ]
then
   echo
   echo " * Failed to create root key. Error:" $RESULT
   exit $RESULT
fi

echo "" > tempParams.txt
echo "" >> tempParams.txt
echo "" >> tempParams.txt
echo "" >> tempParams.txt
echo "root.natf_"$1".com" >> tempParams.txt
echo "" >> tempParams.txt

# Create root ca
openssl req -config ../OpenSslConfigs/root.conf -key root_key.pem -new -x509 -days 7300 -sha256 -extensions v3_ca -out root_ca.pem.crt < tempParams.txt
RESULT=$?
if [ $RESULT != 0 ]
then
   echo
   echo " * Failed to create root ca. Error:" $RESULT
   exit $RESULT
fi

rm tempParams.txt

# Make Intermediate folder
mkdir Intermediate_1
RESULT=$?
if [ $RESULT != 0 ]
then
   echo
   echo " * Error: " $RESULT
   exit $RESULT
fi

cd Intermediate_1

# Create intermediate key
openssl genrsa -out intermediate_key.pem 2048
RESULT=$?
if [ $RESULT != 0 ]
then
   echo
   echo " * Failed to create intermediate key. Error:" $RESULT
   exit $RESULT
fi

echo "" > tempParams.txt
echo "" >> tempParams.txt
echo "" >> tempParams.txt
echo "" >> tempParams.txt
echo "intermediate.natf_"$1".com" >> tempParams.txt
echo "" >> tempParams.txt

# Create Intermediate CSR
openssl req -config ../../OpenSslConfigs/intermediate.conf -new -sha256 -key ./intermediate_key.pem -out ./intermediate_ca.csr < tempParams.txt
RESULT=$?
if [ $RESULT != 0 ]
then
   echo
   echo " * Failed to create intermediate csr. Error:" $RESULT
   exit $RESULT
fi

rm tempParams.txt

# Generate serial number
cd ..
touch root_index
printf '%018x\n' $(($1 * 100000)) > root_serial

# Say yes to signing the cert
echo "y" > tempParams.txt
echo "y" >> tempParams.txt

# Sign intermediate
openssl ca -config ../OpenSslConfigs/root.conf -extensions v3_intermediate_ca -days 3650 -notext -md sha256 -in Intermediate_1/intermediate_ca.csr -out Intermediate_1/intermediate_ca.pem.crt < tempParams.txt
RESULT=$?
if [ $RESULT != 0 ]
then
   echo
   echo " * Failed to create intermediate ca. Error:" $RESULT
   exit $RESULT
fi

rm tempParams.txt

# Verify chain
openssl verify -CAfile root_ca.pem.crt Intermediate_1/intermediate_ca.pem.crt
RESULT=$?
if [ $RESULT != 0 ]
then
   echo
   echo " * Failed to verify intermediate ca. Error:" $RESULT
   exit $RESULT
fi

cd Intermediate_1

# Make leaf folder
mkdir Leaf_1
RESULT=$?
if [ $RESULT != 0 ]
then
   echo
   echo " * Error:" $RESULT
   exit $RESULT
fi

cd Leaf_1

# Create leaf key
openssl genrsa -out leaf_key.pem 2048
RESULT=$?
if [ $RESULT != 0 ]
then
   echo
   echo " * Failed to create leaf key. Error:" $RESULT
   exit $RESULT
fi

echo "" > tempParams.txt
echo "" >> tempParams.txt
echo "" >> tempParams.txt
echo "" >> tempParams.txt
echo "natf_"$1".com" >> tempParams.txt
echo "" >> tempParams.txt

# Create leaf CSR
openssl req -config ../../../OpenSslConfigs/leaf.conf -key leaf_key.pem -new -sha256 -out leaf.csr < tempParams.txt
RESULT=$?
if [ $RESULT != 0 ]
then
   echo
   echo " * Failed to create leaf csr. Error:" $RESULT
   exit $RESULT
fi

rm tempParams.txt

# Generate serial number
cd ..
touch intermediate_index
printf '%018x\n' $(($1 * 100000 + 1000)) > intermediate_serial
RESULT=$?
if [ $RESULT != 0 ]
then
   echo
   echo " * Error:" $RESULT
   exit $RESULT
fi

# Say yes to signing the cert
echo "y" > tempParams.txt
echo "y" >> tempParams.txt

# Sign Leaf
openssl ca -config ../../OpenSslConfigs/intermediate.conf -extensions server_cert -days 3650 -notext -md sha256 -in Leaf_1/leaf.csr -out Leaf_1/leaf.pem.crt < tempParams.txt
RESULT=$?
if [ $RESULT != 0 ]
then
   echo
   echo " * Failed to create leaf cert. Error:" $RESULT
   exit $RESULT
fi

rm tempParams.txt

# Revoke Intermediate with Root
cd ..
openssl ca -config ../OpenSslConfigs/root.conf -revoke Intermediate_1/intermediate_ca.pem.crt
RESULT=$?
if [ $RESULT != 0 ]
then
   echo
   echo " * Failed to revoke intermediate ca. Error:" $RESULT
   exit $RESULT
fi

# Regenerate CRL
echo 01 > root_crlnumber
openssl ca -config ../OpenSslConfigs/root.conf -gencrl -keyfile root_key.pem -cert root_ca.pem.crt -out root.pem.crl
RESULT=$?
if [ $RESULT != 0 ]
then
   echo
   echo " * Failed to generate root crl. Error:" $RESULT
   exit $RESULT
fi

# Convert to DER
openssl crl -inform PEM -in root.pem.crl -outform DER -out root.der.crl
RESULT=$?
if [ $RESULT != 0 ]
then
   echo
   echo " * Failed to convert crl from PEM to DER. Error:" $RESULT
   exit $RESULT
fi

# Verify CRL
openssl crl -inform DER -in root.der.crl -CAfile root_ca.pem.crt -noout
RESULT=$?
if [ $RESULT != 0 ]
then
   echo
   echo " * Failed to verify root crl. Error:" $RESULT
   exit $RESULT
fi

exit 0
