﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 UTitility macros for quicker/clearer google test checks
 *---------------------------------------------------------------------------*/

#pragma once

#ifndef __GTEST_UTIL_H__
#define __GTEST_UTIL_H__


#define NATF_EXPECT_TRUE(__condition__, __fmt__, ... )  \
        do                                              \
        {                                               \
            if( !(__condition__) )                      \
            {                                           \
                 NN_LOG( __fmt__, __VA_ARGS__ );        \
                 FAIL();                                \
            }                                           \
        } while(NN_STATIC_CONDITION(false))


#endif // __GTEST_UTIL_H__

