﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Modules/SslHttpsDownloadModule.h"

namespace NATF {
namespace Tests {

    class SslHttpsDownloadMulti : public BaseTest
    {
        NN_DISALLOW_COPY(SslHttpsDownloadMulti);

    public:
        SslHttpsDownloadMulti(const char* pTestName, const nn::util::Uuid& netProfile, uint32_t timeoutMs, uint32_t connectionCount, const char* pHostName, uint16_t portNum, const char* pResource, nn::ssl::Connection::VerifyOption verifyOption, const MD5Hash::Result& hashResult) NN_NOEXCEPT;
        virtual ~SslHttpsDownloadMulti() NN_NOEXCEPT NN_OVERRIDE;

        static const uint32_t MaxHostNameLen = 64;
        static const uint32_t MaxResourceLen = 128;

    private:
        virtual bool Cleanup() NN_NOEXCEPT NN_OVERRIDE;
        virtual bool Config() NN_NOEXCEPT NN_OVERRIDE;

        uint32_t m_connectionCount;
        Modules::SslHttpsDownload* m_pModules;
        uint16_t m_portNum;
        uint32_t m_timeoutMs;
        nn::ssl::Connection::VerifyOption m_verifyOption;
        MD5Hash::Result m_expectedHash;

        char m_pHostName[MaxHostNameLen];
        char m_pResource[MaxResourceLen];

        bool AllocateModules() NN_NOEXCEPT;
        void FreeModules() NN_NOEXCEPT;
    };

} // namespace Tests
} // namespace NATF
