﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Modules/IperfModule.h"

namespace NATF {
namespace Tests {

    class Iperf : public BaseTest
    {
        NN_DISALLOW_COPY(Iperf);

    public:
        Iperf(const char* pTestName, const nn::util::Uuid& netProfile, uint32_t timeoutMs, bool doIpExchange, const char* pIperfArgString) NN_NOEXCEPT;
        virtual ~Iperf() NN_NOEXCEPT NN_OVERRIDE;

    private:
        virtual bool Cleanup() NN_NOEXCEPT NN_OVERRIDE;
        virtual bool Config() NN_NOEXCEPT NN_OVERRIDE;

        bool AllocateModules() NN_NOEXCEPT;
        void FreeModules() NN_NOEXCEPT;

        void FreeArgV() NN_NOEXCEPT;
        int AllocateArgV(const char* pArgStringIn) NN_NOEXCEPT;

        Modules::Iperf* m_pIperf;
        const uint32_t m_timeoutMs;
        const char* m_pIperfArgString;
        char** m_pArgV;
    };

} // namespace Tests
} // namespace NATF
