--  Sample Lua script for the LuaPlayer! 
--
--
--
---------------------------------------
function print_api(t) -- e.g., call with print_api(Player) to see which member operations are supported
    for k,v in pairs(t) do
        print("member:" .. k)
    end
end
---------------------------------------
function delay(t)
    return function ()                
               while true do 
                  wait(microseconds(t)) 
                  coroutine.yield() 
               end
           end
end
---------------------------------------
function change_rate(my_player)    
    my_player:SetPlaybackRate(0.5) coroutine.yield()
    my_player:SetPlaybackRate(2.0) coroutine.yield()
    my_player:SetPlaybackRate(1.0) 
end
---------------------------------------
function seek_rand(a, b)
    return function(my_player)
        for i=0,10 do        
            my_player:SeekRandom(math.floor(a),math.floor(b)) 
            coroutine.yield()
        end
    end
end
---------------------------------------
function seek_to(...)
    local args = table.pack(...)
    return function (my_player)                 		        
                for i=1,args.n do 								                        
				    my_player:SeekTo(math.floor(my_player:GetDuration() * args[i]))
				    coroutine.yield()
			    end			    
		   end		   
end
---------------------------------------
function main()
    print_api(Player)
    more_files, this_file = get_filenames()    
    while more_files do
        print("Lua loading next file " .. this_file)
        local my_player = Player.new()
        my_player:SetDataSource(this_file)
        my_player:Prepare()
        my_player:Start()                
        my_player:ControlSequence(  seconds(5)  -- control is handed off for 5 seconds
                                  , delay(seconds(1))
                                  , seek_rand(my_player:GetDuration() * 0.25, 
                                              my_player:GetDuration() * 0.5)                                                                      
                                  , seek_to(0.0)
                                  , change_rate                                 
                                  )                                           
        my_player:Stop()
        destroy(my_player)
        more_files, this_file = get_filenames()
    end    
end