﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/fs.h>
#include <movie/Player.h>
#include <movie/BrowserPlayer.h>
#include "NvnRenderer.h"
#include <vector>

class BrowserPlayerSample : public movie::BrowserPlayerObserver
{
public:

    /* Initialize MediaPlayerSample */
    void Initialize(movie::PlayerConfig* config);

    /* Finalize MediaPlayerSample */
    void Finalize(movie::PlayerConfig* config);

    bool IsPlaybackComplete() { return m_PlayBackDone; }

    void SetPlaybackComplete() { m_PlayBackDone = true; }

    void ResetPlaybackComplete() { m_PlayBackDone = false; }

    virtual void OnError(movie::Status movieStatus);

    virtual void OnStateChange(movie::PlayerState state);

    virtual void OnAudioOutputFrameAvailable(movie::AudioFrameInfo* frameInfo);

    virtual void OnVideoOutputFrameAvailable(movie::VideoFrameInfo* frameInfo);

    /* Called repeatedly after Player::Start() while the movie preloads */
    virtual void OnBufferingUpdate(float startTime, float endTime);

    /*  Called after curl_easy_init() for an HTTP request. Return 0 to proceed */
    virtual int32_t OnCurlInit(CURL *easyRequest, const char* uri);

    /*  Called before curl_easy_perform() for an HTTP request. Return 0 to proceed */
    virtual int32_t OnHttpRequest(CURL *easyRequest, const char* uri);

    /* Called before curl_multi_perform() for an HTTP request. Return 0 to proceed */
    virtual int32_t OnMultiConfig(CURLM *multiRequest, const char* uri);

    /* Called after curl_multi_perform() for an HTTP request. Return 0 to proceed. */
    virtual int32_t OnHttpResponse(CURLM *multiRequest, const char* uri);

    virtual void OnOutputBufferAvailable(int trackNumber, movie::TrackType eTrackType);

    virtual void OnOutputBufferAvailable(int trackNumber, movie::TrackType eTrackType, int64_t presentationTimeUs, int32_t index);

    virtual void OnFormatChanged(movie::TrackType eTrackType);

    virtual void OnVideoFrameDropped(int64_t presentationTimeUs);

    ~BrowserPlayerSample() {};

    bool InitNvn(int *windowWidth, int *windowHeight);

    void DestroyNvn();

    void DrawVideoNvn(int videoBufferIndex, int cropWidth, int cropheight, int yOffset, int uvOffset, int ystride, int colorSpace);

    void ResizeTextures(int width, int height);

    void GetNvnInitialized(bool* nvnInitialized) { *nvnInitialized = m_NvnInitialized; }

    void SetNvnInitialized(bool  nvnInitialized) { m_NvnInitialized = nvnInitialized; }

    void SetMoviPlayer(movie::BrowserPlayer*  player) { m_Player = player; }

    void GetMoviPlayer(movie::BrowserPlayer** player) { *player = m_Player; }

    void SetAudioTrackNumber(int32_t audioTrackNumber) { m_AudioTrackNumber = audioTrackNumber; }

    void GetAudioTrackNumber(int32_t *audioTrackNumber) { *audioTrackNumber = m_AudioTrackNumber; }

    void SetVideoTrackNumber(int32_t videoTrackNumber) { m_VideoTrackNumber = videoTrackNumber; }

    void GetVideoTrackNumber(int32_t *videoTrackNumber) { *videoTrackNumber = m_VideoTrackNumber; }

    void AllocateAndRegisterNvnBuffers();


public:
    struct OutputBufferInfo
    {
        int32_t trackNumber;
        int32_t bufferIndex;
    };
    nn::os::MutexType m_VideoOutputBuffersListMutex;
    std::vector<OutputBufferInfo> m_VideoOutputBuffersList;
    int32_t m_VideoOutputBufferSize;
    int32_t m_VideoTrackNumber;
    char *m_PcmBuffer;
    int32_t m_PcmBufferSize;

    static const int m_videoBufferCount = 2;
    NvnBuffer m_videoBufferYUV[m_videoBufferCount];
    movie::Buffer m_videobufferArray[m_videoBufferCount];
    int32_t m_videoBufferIndexArray[m_videoBufferCount];
    int32_t m_PresentationIndex;
    nn::os::EventType m_StartPlaybackEvent;
    NvnWindow m_window;
    movie::PlayerConfig m_PlayerConfig;

    int m_CropWidth;
    int m_CropHeight;
    movie::MediaData m_BufferProperty;

private:
    nn::mem::StandardAllocator m_allocator;
    void *m_pAllocatorMemory;

    NvnDevice m_device;
    NvnQueue m_queue;

    void *m_pShaderPoolMemory;
    void *m_pVertexPoolMemory;
    void *m_pCommandMemory;
    void *m_pTextureMemory;
    void *m_pBufferMemory;
    void *m_pShaderScratchMemory;
    void *m_pUniformMemory;
    NvnMemoryPool m_shaderPool;
    NvnMemoryPool m_vertexPool;
    NvnMemoryPool m_commandPool;
    NvnMemoryPool m_textureMemoryPool;
    NvnMemoryPool m_bufferMemory;
    NvnMemoryPool m_shaderScratchPool;
    NvnMemoryPool m_uniformPool;

    NvnProgram m_program;
    NvnShaderSerialize m_vertexShaderFile;
    NvnShaderSerialize m_fragmentShaderFile;

    NvnCommandBuffer m_drawCommands;
    NvnCommandBuffer m_renderTargetCommand;

    NvnTextureSamplerPool m_texturePool;
    NvnTexture m_videoTextureY;

    static const int m_RgbTextureCount = 1;
    NvnTexture m_RgbTextures[m_RgbTextureCount];
    NVNtextureHandle m_RgbTextureHandles[m_RgbTextureCount];
    unsigned m_RgbTextureIds[m_RgbTextureCount];

    NvnTexture m_videoTextureUV;
    NvnSampler m_videoSampler;
    NVNtextureHandle m_videoTextureHandleY;
    NVNtextureHandle m_videoTextureHandleUV;
    unsigned m_videoTextureIdY;
    unsigned m_videoTextureIdUV;
    NvnBuffer m_vertexDataBuffer;
    NvnBuffer m_fragmentDataBuffer;
    NvnBuffer m_squareMesh;
    NvnBuffer m_uniformBuffer;
    unsigned m_uniformUsefulSize;

    NVNblendState m_blendState;
    NVNchannelMaskState m_channelMaskState;
    NVNcolorState m_colorState;
    NVNmultisampleState m_multisampleState;
    NVNpolygonState m_polygonState;
    NVNdepthStencilState m_depthStencilState;

    DataSection m_vertexDataSection;
    DataSection m_vertexControlSection;
    DataSection m_fragmentDataSection;
    DataSection m_fragmentControlSection;

    NVNcommandHandle m_commandHandleDraw;

    bool m_PlayBackDone;
    bool m_NvnInitialized;

    movie::BrowserPlayer* m_Player;
    int32_t m_AudioTrackNumber;
};
