﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <cstdint>

#include <nn/os/os_Mutex.h>
#include <nn/nn_SdkLog.h>

#include <string>

#include "UntrackedAllocator.h"
#include <experimental/vector>

namespace pmr = ::std::experimental::pmr;

namespace movie { namespace sample {

class HeapTracker
{
public:
    explicit HeapTracker(std::string_view name)
        : name_{name}
        , allocations_{pmr::polymorphic_allocator<unsigned char>{&memory_resource_}}
    {}

    void Track(void *memory, size_t size);
    void Untrack(void *memory);
    void OutputUsage();

    nn::os::Mutex m_mutex{false};

private:

    std::string_view name_;

    struct AllocationInfo
    {
        void *address_;
        size_t size_;
    };

    int64_t max_size_{};
    int64_t current_size_{};

    movie::sample::UntrackedAllocator memory_resource_{8};
    pmr::vector<AllocationInfo> allocations_;
};

}}

