﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//
//   Simple test to see how to get a version of malloc to work based
//   on ExpHeap code, and how to redefine malloc/free to call our version.
//
//
//   lmem source code in : sdk/Programs/Alice/Sources/Libraries/lmem
//
//---------------------------------------------------------------------------


#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>

#ifdef WIN32
//#define USE_WIN32_MALLOC_IMPLEMENTATION               // #define if want to use Win32 code rather than horizons..
#endif

#ifdef USE_WIN32_MALLOC_IMPLEMENTATION        // if horizon, we want this header file and link to this library
    #include <Win\platform\WinAlloc.h>        // but if want to use these Win32 malloc implementation, use this instead.
    #pragma comment(lib, "libmm_windows.lib") // not exactly sure this is going to work in Horizon - need to test
#else
    #include <Horizon\platform\HorizonAlloc.h>
    #pragma comment(lib, "libmm_horizon.lib")
#endif




//---------------------------------------------------------------------------
//  Test Main
//---------------------------------------------------------------------------

extern "C" void nnMain()
{
    //int     argc = nnt::GetHostArgc();
    //char **argv = nnt::GetHostArgv();

    MV_MemoryHeapInit(64);    // allocate 64 MB of for total heap space
    MV_HeapCreate(64);        // specify how much of total heap space used by our malloc…


    for(int j = 1; j < 1000; j++)
    {
        void *addr = malloc(j);
        NN_ASSERT(addr != NULL, "Allocate Failed\n");
        free(addr);
    }

    const char testStr[] = "This is a test";
    char *dst1 = (char*) malloc(strlen(testStr) + 1);
    NN_ASSERT(dst1 != NULL, "Malloc failed\n");
    strcpy(dst1, testStr);
    NN_ASSERT(0 == strcmp(dst1, testStr),"malloc/strcpy failed\n");

    char *dst2 = strdup(testStr);
    NN_ASSERT(NULL != dst2 && 0 == strcmp(dst2, testStr), "strdup failed\n");

    char *dst3 = (char*) realloc(dst1, 2 * strlen(dst1));
    NN_ASSERT(NULL != dst3 && 0 == strcmp(dst3, testStr),"realloc failed");

    char *dst4 = (char*) calloc(strlen(testStr) + 1,1);
    NN_ASSERT(NULL != dst4 && 0 == dst4[0] && 0 == dst4[1], "calloc didn't work");


    free(dst4);
    free(dst3);
    free(dst2);
    // free(dst1);       // realloc - don't free

    {
        typedef struct foo {int x; int y; int z;} foo;
        foo *pX = new foo;
        delete pX;

        foo *rX = new foo[100];
        delete[] rX;
    }


    NN_LOG("Done Alloc\n");

    MV_HeapDestroy();
}

