﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/nn_Common.h>
#include <nn/migration/idc/migration_SharedBufferConnection.h>
#include <nn/migration/idc/migration_SharedBufferConnectionManager.h>
#include <nn/os.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/nntest.h>
#include "testMigrationIdc_Common.h"
#include "testMigrationIdc_ConnectionTestCases.h"

using namespace nn;

// 作成した接続で通信ができることを確認する。接続後の Cancel, Timeout 等の挙動は SharedBufferConnectionTest の方で確認。

const size_t ManagerBufferSize = 32 * 1024;
Bit8 g_ManagerBuffer[ManagerBufferSize];

TEST(MigrationIdcSharedBufferConnectionManagerTest, CreateConnection)
{
    migration::idc::SharedBufferConnectionManager sharedBufferConnectionManager(g_ManagerBuffer, ManagerBufferSize);

    migration::idc::SharedBufferConnection server, client;

    ASSERT_TRUE(sharedBufferConnectionManager.CreateConnection(&server, &client, 1024));

    TestBasicSendReceive<>(server, client);
}

TEST(MigrationIdcSharedBufferConnectionManagerTest, CreateServerAndConnect)
{
    migration::idc::SharedBufferConnectionManager sharedBufferConnectionManager(g_ManagerBuffer, ManagerBufferSize);

    migration::idc::SharedBufferConnection server, client;
    int serverId;
    EXPECT_TRUE(sharedBufferConnectionManager.CreateServer(&server, &serverId, 1024));
    EXPECT_TRUE(sharedBufferConnectionManager.Connect(&client, serverId));

    TestBasicSendReceive<>(server, client);
}

TEST(MigrationIdcSharedBufferConnectionManagerTest, WaitConnection)
{
    migration::idc::SharedBufferConnectionManager sharedBufferConnectionManager(g_ManagerBuffer, ManagerBufferSize);

    migration::idc::SharedBufferConnection server;
    int serverId;
    EXPECT_TRUE(sharedBufferConnectionManager.CreateServer(&server, &serverId, 1024));

    struct Tmp
    {
        migration::idc::SharedBufferConnectionManager* pManager;
        int id;
    };

    Tmp tmp{ &sharedBufferConnectionManager, serverId };
    RunOnThreadA([](void *arg)
        {
            auto pTmp = reinterpret_cast<Tmp*>(arg);
            EXPECT_TRUE(pTmp->pManager->WaitConnection(pTmp->id, 5));
        }, &tmp);

    // WaitConnection の方が先に呼ばれて、待つ事を確認するための Sleep。
    os::SleepThread(nn::TimeSpan::FromSeconds(1));
    migration::idc::SharedBufferConnection client;
    EXPECT_TRUE(sharedBufferConnectionManager.Connect(&client, serverId));

    DestroyThreadA();

    TestBasicSendReceive<>(server, client);
}
