﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>

#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/mem.h>

namespace {

struct RealTestCommand
{
    char   type;       // 1=alloc 2=free 3=realloc
    size_t index;      // index number for free/realloc
    size_t size;       // size for alloc
    size_t alignment;
    void*  ptr;

};

RealTestCommand g_CommandList[] = {
    { 1, 0, 40, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 4, 8, nullptr },
    { 1, 0, 72, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 772, 8, nullptr },
    { 1, 0, 72, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 16, 8, nullptr },
    { 2, 9, 0, 0, nullptr },
    { 2, 10, 0, 0, nullptr },
    { 2, 11, 0, 0, nullptr },
    { 1, 0, 8388608, 8, nullptr },
    { 1, 0, 72, 8, nullptr },
    { 1, 0, 16, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 2, 18, 0, 0, nullptr },
    { 1, 0, 104, 8, nullptr },
    { 1, 0, 16, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 160, 8, nullptr },
    { 1, 0, 84, 8, nullptr },
    { 1, 0, 16, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8208, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 16, 8, nullptr },
    { 1, 0, 1832, 8, nullptr },
    { 1, 0, 16, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 6, 8, nullptr },
    { 3, 99, 12,  0, nullptr },
    { 3, 100, 12,  0, nullptr },
    { 3, 100, 12,  0, nullptr },
    { 3, 100, 12,  0, nullptr },
    { 2, 100, 0, 0, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 44, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 16, 8, nullptr },
    { 1, 0, 16, 8, nullptr },
    { 1, 0, 128, 8, nullptr },
    { 1, 0, 16, 8, nullptr },
    { 1, 0, 21, 8, nullptr },
    { 1, 0, 19, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 21, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 22, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 632, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 16, 8, nullptr },
    { 1, 0, 21, 8, nullptr },
    { 1, 0, 19, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 21, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 444, 8, nullptr },
    { 1, 0, 160, 8, nullptr },
    { 1, 0, 92, 8, nullptr },
    { 2, 133, 0, 0, nullptr },
    { 1, 0, 52, 8, nullptr },
    { 1, 0, 52, 8, nullptr },
    { 2, 137, 0, 0, nullptr },
    { 1, 0, 91, 8, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 48, 8, nullptr },
    { 1, 0, 48, 8, nullptr },
    { 2, 143, 0, 0, nullptr },
    { 1, 0, 4, 8, nullptr },
    { 1, 0, 56, 8, nullptr },
    { 1, 0, 4096, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 56, 8, nullptr },
    { 1, 0, 12, 8, nullptr },
    { 1, 0, 108, 8, nullptr },
    { 1, 0, 384, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 48, 8, nullptr },
    { 1, 0, 8195, 8, nullptr },
    { 1, 0, 256, 8, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 288, 8, nullptr },
    { 1, 0, 131075, 8, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 520, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 12, 8, nullptr },
    { 1, 0, 12, 8, nullptr },
    { 1, 0, 4, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 56, 8, nullptr },
    { 1, 0, 4096, 8, nullptr },
    { 1, 0, 96, 8, nullptr },
    { 1, 0, 67108864, 131072, nullptr },
    { 1, 0, 56, 8, nullptr },
    { 1, 0, 96, 8, nullptr },
    { 1, 0, 288, 8, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 4096, 4096, nullptr },
    { 1, 0, 68, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 52, 8, nullptr },
    { 1, 0, 96, 8, nullptr },
    { 1, 0, 16352, 8, nullptr },
    { 1, 0, 69635, 8, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 299011, 8, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 40, 8, nullptr },
    { 2, 214, 0, 0, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 1288, 8, nullptr },
    { 1, 0, 136, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 524288, 8, nullptr },
    { 1, 0, 72, 8, nullptr },
    { 1, 0, 264, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 67108864, 131072, nullptr },
    { 1, 0, 288, 8, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 440, 8, nullptr },
    { 1, 0, 616, 8, nullptr },
    { 1, 0, 336, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 320, 8, nullptr },
    { 1, 0, 128, 8, nullptr },
    { 1, 0, 16, 8, nullptr },
    { 1, 0, 4, 8, nullptr },
    { 1, 0, 6, 8, nullptr },
    { 3, 255, 12,  0, nullptr },
    { 3, 256, 12,  0, nullptr },
    { 3, 256, 12,  0, nullptr },
    { 3, 256, 12,  0, nullptr },
    { 2, 256, 0, 0, nullptr },
    { 2, 252, 0, 0, nullptr },
    { 2, 253, 0, 0, nullptr },
    { 1, 0, 336, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 320, 8, nullptr },
    { 1, 0, 128, 8, nullptr },
    { 1, 0, 16, 8, nullptr },
    { 1, 0, 6, 8, nullptr },
    { 3, 268, 12,  0, nullptr },
    { 3, 269, 12,  0, nullptr },
    { 3, 269, 12,  0, nullptr },
    { 3, 269, 12,  0, nullptr },
    { 2, 269, 0, 0, nullptr },
    { 2, 266, 0, 0, nullptr },
    { 2, 267, 0, 0, nullptr },
    { 1, 0, 336, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 320, 8, nullptr },
    { 1, 0, 128, 8, nullptr },
    { 1, 0, 16, 8, nullptr },
    { 1, 0, 6, 8, nullptr },
    { 3, 281, 12,  0, nullptr },
    { 3, 282, 12,  0, nullptr },
    { 3, 282, 12,  0, nullptr },
    { 3, 282, 12,  0, nullptr },
    { 2, 282, 0, 0, nullptr },
    { 2, 279, 0, 0, nullptr },
    { 2, 280, 0, 0, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 12, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 163840, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 131072, 131072, nullptr },
    { 2, 305, 0, 0, nullptr },
    { 2, 306, 0, 0, nullptr },
    { 2, 307, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 2, 324, 0, 0, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 2, 326, 0, 0, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 2, 330, 0, 0, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 2, 332, 0, 0, nullptr },
    { 2, 328, 0, 0, nullptr },
    { 2, 329, 0, 0, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 100, 8, nullptr },
    { 2, 336, 0, 0, nullptr },
    { 2, 337, 0, 0, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 131072, 131072, nullptr },
    { 1, 0, 288, 8, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 2, 360, 0, 0, nullptr },
    { 2, 359, 0, 0, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 131072, 131072, nullptr },
    { 1, 0, 288, 8, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 2, 382, 0, 0, nullptr },
    { 2, 381, 0, 0, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 240, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 2228224, 131072, nullptr },
    { 2, 388, 0, 0, nullptr },
    { 2, 389, 0, 0, nullptr },
    { 2, 390, 0, 0, nullptr },
    { 1, 0, 0, 8, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 1, 0, 352, 8, nullptr },
    { 1, 0, 42, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 399, 0, 0, nullptr },
    { 2, 400, 0, 0, nullptr },
    { 2, 401, 0, 0, nullptr },
    { 2, 398, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 42, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 420, 0, 0, nullptr },
    { 2, 421, 0, 0, nullptr },
    { 2, 422, 0, 0, nullptr },
    { 2, 419, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 42, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 441, 0, 0, nullptr },
    { 2, 442, 0, 0, nullptr },
    { 2, 443, 0, 0, nullptr },
    { 2, 440, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 43, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 462, 0, 0, nullptr },
    { 2, 463, 0, 0, nullptr },
    { 2, 464, 0, 0, nullptr },
    { 2, 461, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 42, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 483, 0, 0, nullptr },
    { 2, 484, 0, 0, nullptr },
    { 2, 485, 0, 0, nullptr },
    { 2, 482, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 43, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 504, 0, 0, nullptr },
    { 2, 505, 0, 0, nullptr },
    { 2, 506, 0, 0, nullptr },
    { 2, 503, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 41, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 525, 0, 0, nullptr },
    { 2, 526, 0, 0, nullptr },
    { 2, 527, 0, 0, nullptr },
    { 2, 524, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 42, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 546, 0, 0, nullptr },
    { 2, 547, 0, 0, nullptr },
    { 2, 548, 0, 0, nullptr },
    { 2, 545, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 41, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 567, 0, 0, nullptr },
    { 2, 568, 0, 0, nullptr },
    { 2, 569, 0, 0, nullptr },
    { 2, 566, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 42, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 588, 0, 0, nullptr },
    { 2, 589, 0, 0, nullptr },
    { 2, 590, 0, 0, nullptr },
    { 2, 587, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 42, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 609, 0, 0, nullptr },
    { 2, 610, 0, 0, nullptr },
    { 2, 611, 0, 0, nullptr },
    { 2, 608, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 42, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 630, 0, 0, nullptr },
    { 2, 631, 0, 0, nullptr },
    { 2, 632, 0, 0, nullptr },
    { 2, 629, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 42, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 651, 0, 0, nullptr },
    { 2, 652, 0, 0, nullptr },
    { 2, 653, 0, 0, nullptr },
    { 2, 650, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 42, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 672, 0, 0, nullptr },
    { 2, 673, 0, 0, nullptr },
    { 2, 674, 0, 0, nullptr },
    { 2, 671, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 42, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 693, 0, 0, nullptr },
    { 2, 694, 0, 0, nullptr },
    { 2, 695, 0, 0, nullptr },
    { 2, 692, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 42, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 714, 0, 0, nullptr },
    { 2, 715, 0, 0, nullptr },
    { 2, 716, 0, 0, nullptr },
    { 2, 713, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 42, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 735, 0, 0, nullptr },
    { 2, 736, 0, 0, nullptr },
    { 2, 737, 0, 0, nullptr },
    { 2, 734, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 43, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 756, 0, 0, nullptr },
    { 2, 757, 0, 0, nullptr },
    { 2, 758, 0, 0, nullptr },
    { 2, 755, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 44, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 777, 0, 0, nullptr },
    { 2, 778, 0, 0, nullptr },
    { 2, 779, 0, 0, nullptr },
    { 2, 776, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 42, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 393216, 131072, nullptr },
    { 2, 183, 0, 0, nullptr },
    { 2, 184, 0, 0, nullptr },
    { 2, 181, 0, 0, nullptr },
    { 1, 0, 96, 8, nullptr },
    { 1, 0, 56, 8, nullptr },
    { 1, 0, 96, 8, nullptr },
    { 2, 798, 0, 0, nullptr },
    { 2, 799, 0, 0, nullptr },
    { 2, 800, 0, 0, nullptr },
    { 2, 797, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 42, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 825, 0, 0, nullptr },
    { 2, 826, 0, 0, nullptr },
    { 2, 827, 0, 0, nullptr },
    { 2, 824, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 42, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 262144, 131072, nullptr },
    { 2, 846, 0, 0, nullptr },
    { 2, 847, 0, 0, nullptr },
    { 2, 848, 0, 0, nullptr },
    { 2, 845, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 192, 8, nullptr },
    { 1, 0, 520, 8, nullptr },
    { 1, 0, 1901248, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 232938, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 2, 391, 0, 0, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 262144, 131072, nullptr },
    { 2, 877, 0, 0, nullptr },
    { 2, 878, 0, 0, nullptr },
    { 2, 879, 0, 0, nullptr },
    { 1, 0, 0, 8, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 1, 0, 16, 8, nullptr },
    { 1, 0, 42, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 786432, 131072, nullptr },
    { 2, 888, 0, 0, nullptr },
    { 2, 889, 0, 0, nullptr },
    { 2, 890, 0, 0, nullptr },
    { 2, 887, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 110240, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 39990, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 2, 880, 0, 0, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 131072, 131072, nullptr },
    { 2, 919, 0, 0, nullptr },
    { 2, 920, 0, 0, nullptr },
    { 2, 921, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 2, 938, 0, 0, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 2, 940, 0, 0, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 2, 944, 0, 0, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 2, 946, 0, 0, nullptr },
    { 2, 942, 0, 0, nullptr },
    { 2, 943, 0, 0, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 1, 0, 80, 8, nullptr },
    { 1, 0, 100, 8, nullptr },
    { 2, 950, 0, 0, nullptr },
    { 2, 951, 0, 0, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 64, 8, nullptr },
    { 1, 0, 32, 8, nullptr },
    { 1, 0, 36, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 8, 8, nullptr },
    { 1, 0, 24, 8, nullptr },
    { 1, 0, 131072, 131072, nullptr },
    { 2, 963, 0, 0, nullptr },
    { 2, 964, 0, 0, nullptr },
    { 2, 965, 0, 0, nullptr },
    { 1, 0, 120, 8, nullptr },
    { 1, 0, 28, 8, nullptr },
    { 1, 0, 112, 8, nullptr },
    { 1, 0, 20, 8, nullptr },
    { 1, 0, 112, 8, nullptr }
};

/**
 * @brief   テストに与えるパラメータです。
 */
enum StandardAllocatorTestParam
{
    StandardAllocatorTestParam_DisableThreadCache = 0,  //!< スレッドキャッシュを利用しない
    StandardAllocatorTestParam_EnableThreadCache        //!< スレッドキャッシュを利用する
};

/**
 * @brief   テストで利用するテストフィクスチャです。
 */
class StandardAllocatorRealPattern2Test : public ::testing::TestWithParam< std::pair<StandardAllocatorTestParam, size_t> >
{
protected:

    /**
     * @brief   テスト開始時に毎回呼び出される関数です。
     */
    virtual void SetUp()
    {
        ASSERT_TRUE(nn::os::IsVirtualAddressMemoryEnabled());
        std::pair<StandardAllocatorTestParam, size_t> pattern = GetParam();
        size_t virtualSize = pattern.second * 1024 * 1024 * 1024;
        ASSERT_LE(virtualSize, 63ull * 1024 * 1024 * 1024); // NX での最大値

        // ヒープを初期化
        if (pattern.first == StandardAllocatorTestParam_DisableThreadCache)
        {
            NN_LOG("ThreadCache: disabled heapSize: %zu GiB\n", pattern.second);
            m_Allocator.Initialize(nullptr, virtualSize);
        }
        else
        {
            NN_LOG("ThreadCache: enabled heapSize: %zu GiB\n", pattern.second);
            m_Allocator.Initialize(nullptr, virtualSize, true);
        }
    }

    /**
     * @brief   テスト終了時に毎回呼び出される関数です。
     */
    virtual void TearDown()
    {
        m_Allocator.Finalize();
    }

protected:
    nn::mem::StandardAllocator m_Allocator;
};

}

/**
 * @brief   過去実際に断片化が起きたパターンで問題がないことを確認します。
 */
TEST_P(StandardAllocatorRealPattern2Test, GfxIndirectIllumination)
{
    for (auto&& cmd : g_CommandList)
    {
        switch (cmd.type)
        {
        case 1: // alloc
            cmd.ptr = m_Allocator.Allocate(cmd.size, cmd.alignment);
            if (cmd.size != 0)
            {
                ASSERT_TRUE(cmd.ptr != NULL);
            }
            break;
        case 2: // free
            m_Allocator.Free(g_CommandList[cmd.index].ptr);
            break;
        case 3: // realloc
            cmd.ptr = m_Allocator.Reallocate(g_CommandList[cmd.index].ptr, cmd.size);
            if (cmd.size != 0)
            {
                ASSERT_TRUE(cmd.ptr != NULL);
            }
            break;
        case 4: // dump
            m_Allocator.Dump();
            break;
        default:
            break;
        }
    }
}

INSTANTIATE_TEST_CASE_P(VirtualSpaceSize,
                        StandardAllocatorRealPattern2Test,
                        testing::Values(std::make_pair(StandardAllocatorTestParam_DisableThreadCache, 4),
                                        std::make_pair(StandardAllocatorTestParam_DisableThreadCache, 60),
                                        std::make_pair(StandardAllocatorTestParam_EnableThreadCache, 4),
                                        std::make_pair(StandardAllocatorTestParam_EnableThreadCache, 60)));
