﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>

#include <nn/nn_Assert.h>
#include <nn/nn_Common.h>

#include "RandomList.h"

void RandomList::Init(uint32_t N) NN_NOEXCEPT
{
    NN_ASSERT(N <= 2 * MaxListBitWidth);

    for (int i = 0; i < MaxListSize; i++)
    {
        m_OddList[i] = 0;
        m_EvenList[i] = 0;
    }

    m_OddListBitWidth = N / 2;
    m_EvenListBitWidth = N / 2 + 1; // 最下位ビット(0) は even に含まれるので、even は必ず odd 以上

    const uint32_t oddListSize = 1 << m_OddListBitWidth;
    for (int i = 0; i < oddListSize; i++)
    {
        for (int bit = 0; bit < MaxListBitWidth; bit++)
        {
            if (i & (1 << bit))
            {
                m_OddList[i] |= (1 << (bit * 2 + 1));
            }
        }
    }

    const uint32_t evenListSize = 1 << m_EvenListBitWidth;
    for (int i = 0; i < evenListSize; i++)
    {
        for (int bit = 0; bit < MaxListBitWidth; bit++)
        {
            if (i & (1 << bit))
            {
                m_EvenList[i] |= (1 << (bit * 2));
            }
        }
    }

    Shuffle(m_OddList, oddListSize, oddListSize);
    Shuffle(m_EvenList, evenListSize, evenListSize);
}

void RandomList::Shuffle(uint32_t *buffer, uint32_t size, uint32_t count) NN_NOEXCEPT
{
    for (int i = 0; i < count; i++)
    {
        int index1 = rand() % size;
        int index2 = rand() % size;

        uint32_t tmp = buffer[index1];
        buffer[index1] = buffer[index2];
        buffer[index2] = tmp;
    }
}
