﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/os.h>

#include "DummyThread.h"

namespace {

const int VeryBigNumber = 1024 * 1024 * 1024;

// 計算を行うコアの番号リスト
const int CoreNumberList[] = {2}; // コア 0 は描画、コア 1 はメモリテストを行うので、コア 2 のみ

const int ThreadCount = sizeof(CoreNumberList) / sizeof(CoreNumberList[0]);
const size_t ThreadStackSize = 4096;

uint8_t g_ThreadStack[ThreadCount][ThreadStackSize] NN_ALIGNAS(nn::os::ThreadStackAlignment);
nn::os::ThreadType g_Thread[ThreadCount];

void DummyThread(void *arg)
{
    NN_LOG("Start dummy thread.\n");

    while(true)
    {
        volatile int sum = 0; // 最適化を抑制
        for (int i = 0; i < VeryBigNumber; i++)
        {
            for (int j = 0; j < VeryBigNumber; j++)
            {
                for (int k = 0; k < VeryBigNumber; k++)
                {
                    // ダミーの適当な計算
                    sum += (i * 3 + j * 2 + k);
                }
            }
        }
        NN_LOG("Dummy Output (sum: %d)\n", sum);
    }
}

}

void StartDummyThread()
{
    for (int i = 0; i < ThreadCount; i++)
    {
        nn::os::CreateThread(&g_Thread[i], DummyThread, nullptr, g_ThreadStack[i], ThreadStackSize, nn::os::LowestThreadPriority, CoreNumberList[i]);
        nn::os::StartThread(&g_Thread[i]);
    }
}
