<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Generate meta file of add-on content

    .DESCRIPTION
        Generate meta file of add-on content
#>
[CmdletBinding()]
Param
(
    [Parameter(Mandatory=$True)]
    [string]
    $OutputDirectoryPath,

    [string]
    $BaseId = "0x0005000c10000000",

    [Parameter(Mandatory=$True)]
    [Int]
    $StartIndex,

    [Parameter(Mandatory=$True)]
    [Int]
    $Count,

    [Parameter(Mandatory=$True)]
    [string]
    $OutputFileName
)

trap [Exception]
{
    Write-Host $_
    exit 1
}


$newDir = New-Item $OutputDirectoryPath -Type directory -Force

$xmls = @()
for($i = 0; $i -lt $Count; $i++)
{
    $base = [Convert]::ToInt64($BaseId, 16)
    $index = $StartIndex + $i
    $aocId = [String]::Format("0x{0:x16}", ($base + $index + 0x1000))
    $appId = [String]::Format("0x{0:x16}", $base)
    $output = Join-Path $OutputDirectoryPath "$aocId.meta"
    $template = @"
  <AddOnContent>
    <ApplicationId>$appId</ApplicationId>
    <Index>$index</Index>
    <RequiredApplicationReleaseVersion>0</RequiredApplicationReleaseVersion>
    <ReleaseVersion>0</ReleaseVersion>
    <DataPath>Data</DataPath>
    <Tag>Tag $index</Tag>
  </AddOnContent>
"@
    $xmls += $template
}

$xml = $xmls -join "`n"
$template = @"
<?xml version="1.0"?>
<Meta>
$xml
</Meta>
"@
$output = Join-Path $OutputDirectoryPath $OutputFileName
$template | Set-Content $output -Encoding UTF8
