﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/ldn.h>
#include <nn/socket.h>
#include <nn/socket/socket_TypesPrivate.h>

namespace
{
    const int       InitCount = 4;
    const int       SettingCount = 11;
    const int       ModeCount = 2;
    const int       LdnParameterCount = 6;
    const int       PacketParameterCount = 3;
    const int       RateMax = 3000;
    const int       RateMin = 1;
    const int       PacketSizeMax = 1400;
    const int       PacketSizeMin = 100;
    const size_t    BufferSize = 32;
}


enum ApplicationState
{
    ApplicationState_Initialized,
    ApplicationState_Setting,
    ApplicationState_Ldn,
    ApplicationState_Communicating,
    ApplicationState_Exit
};

enum NetworkState
{
    NetworkState_AP_Creating,
    NetworkState_AP_Created,
    NetworkState_AP_Destroying,
    NetworkState_AP_Destroyed,
    NetworkState_STA_Connecting,
    NetworkState_STA_Connected,
    NetworkState_STA_Disconnecting,
    NetworkState_STA_Disconnected
};

enum InitCursor
{
    InitCursor_None,
    InitCursor_Start,
    InitCursor_Setting,
    InitCursor_Exit,
    InitCursor_CountMax
};

enum SettingCursor
{
    SettingCursor_None,
    SettingCursor_Group,
    SettingCursor_Mode,
    SettingCursor_FrequencyBand,
    SettingCursor_Channel,
    SettingCursor_Security,
    SettingCursor_NodeCountMax,
    SettingCursor_CastTo,
    SettingCursor_Rate,
    SettingCursor_PacketSize,
    SettingCursor_CountMax
};

enum LdnMode
{
    LdnMode_AccessPoint,
    LdnMode_Station
};

enum LdnBand
{
    LdnBand_5GHz,
    LdnBand_2GHz
};

enum LdnChannel5G
{
    LdnChannel5G_None,
    LdnChannel5G_36,
    LdnChannel5G_40,
    LdnChannel5G_44,
    LdnChannel5G_48,
    LdnChannel5G_CountMax
};

enum LdnChannel2G
{
    LdnChannel2G_None,
    LdnChannel2G_1,
    LdnChannel2G_6,
    LdnChannel2G_11,
    LdnChannel2G_CountMax
};

enum LdnSecurity
{
    LdnSecurity_StaticAES,
    LdnSecurity_None
};

enum PacketCastTo
{
    PacketCastTo_None,
    PacketCastTo_Broadcast,
    PacketCastTo_UnicastToAP,
    PacketCastTo_UnicastToAll,
    PacketCastTo_Ping,
    PacketCastTo_CountMax
};

enum Touch
{
    Touch_None,
    Touch_A,
    Touch_B,
    Touch_X,
    Touch_Y,
    Touch_Up,
    Touch_Down,
    Touch_Right,
    Touch_Left
};

struct Region
{
    int xMin;
    int xMax;
    int yMin;
    int yMax;
};

struct LdnSetting
{
    int                         group;
    int                         mode;
    int                         band;
    int                         channel5GHz;
    int                         channel2GHz;
    int                         secrity;
    int8_t                      nodeCountMax;
};

struct TranslateSetting
{
    int                         castTo;
    int                         rate;
    int16_t                     packetSize;
};

struct PacketData
{
    uint32_t                    counter;
    uint16_t                    dataSize;
    uint8_t                     data[PacketSizeMax];
};

struct IcmpPacketData
{
    nn::socket::Icmp hdr;
    uint8_t tick[8];
};

struct ReceiveInfo
{
    int                         startTime;
    int                         startCount;
    int                         packetCount;
    int                         packetLoss;
    int                         previousPacketLoss;
    uint64_t                    receivePacketSize;
    uint64_t                    previousReceivePacketSize;
    double                      packetLossRate;
    double                      packetDataRate;
    int64_t                     rtt;
};

struct ApplicationResource
{
    nn::os::ThreadType          ldnThread;
    nn::os::ThreadType          monitorThread;
    nn::os::ThreadType          sendThread;
    nn::os::ThreadType          receiveThread;
    nn::os::ThreadType          timeThread;
    nn::os::SystemEventType     stateChangeEvent;
    nn::os::EventType           cancelEvent;
    nn::os::EventType           stopCommunicateEvent;
    nn::os::MutexType           mutex;
    nn::ldn::NetworkInfo        networkInfo;
    nn::ldn::Ipv4Address        ipv4Address;
    nn::ldn::SubnetMask         subnetMask;
    int                         time;
    bool                        sendWait;
    bool                        receiveError;
    bool                        packetSwitched;
    uint32_t                    counter[nn::ldn::NodeCountMax];
    int                         socket;
    int                         icmp_sock;
    ApplicationState            appState;
    NetworkState                netState;
    int                         initCursor;
    int                         settingCursor;
    bool                        focus;
    Touch                       touch;
    int                         diffX;
    int                         diffY;
    LdnSetting                  ldnSetting;
    TranslateSetting            translateSetting;
    ReceiveInfo                 receiveInfo[nn::ldn::NodeCountMax];
};

