﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include "Definition.h"
#include "Types.h"
#include "Util.h"


void InitializeSocket() NN_NOEXCEPT;

void FinalizeSocket() NN_NOEXCEPT;

void CreateSocket(ApplicationResource* pApp) NN_NOEXCEPT;

void DestroySocket(ApplicationResource* pApp) NN_NOEXCEPT;

void SendThread(void* arg) NN_NOEXCEPT;

void ReceiveThread(void* arg) NN_NOEXCEPT;
