﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include "Types.h"

void StationMonitorThread(void* arg) NN_NOEXCEPT;

nn::Result Scan(ApplicationResource* pApp, int* pOutScanResultCount) NN_NOEXCEPT;

nn::Result Connect(ApplicationResource* pApp, const nn::ldn::NetworkInfo& network) NN_NOEXCEPT;

void Disconnect(ApplicationResource* pApp) NN_NOEXCEPT;

void LdnStation(void* arg) NN_NOEXCEPT;

/*
extern "C" void nnMain()
{
    {
        // デバッグパッドの入力を取得します。
        nn::hid::GetDebugPadState(&padState);

        // トリガー入力を取得します。
        trigger = (~previousPadState.buttons) & padState.buttons;
        previousPadState = padState;

        // 各状態に応じた処理です。
        if (app.state == ApplicationState_Initialized)
        {
            if (trigger.Test<nn::hid::DebugPadButton::A>())
            {
                app.state = ApplicationState_Connecting;
                NN_LOG("入力を受け付けました。 LDN ネットワークをスキャンして接続します。\n\n");
                nn::os::InitializeEvent(
                    &app.cancelEvent, false, nn::os::EventClearMode_ManualClear);
                nn::os::InitializeMutex(&app.mutex, false, 0);
                NNS_LDN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::CreateThread(
                    &ldnThread, LdnStation, &app,
                    g_LdnThreadStack, sizeof(g_LdnThreadStack), LdnThreadPriority));
                nn::os::StartThread(&ldnThread);
            }
        }
        else if (app.state == ApplicationState_Connected)
        {
            if (trigger.Test<nn::hid::DebugPadButton::B>())
            {
                app.state = ApplicationState_Disconnecting;
                NN_LOG("入力を受け付けました。 LDN ネットワークから切断します。\n\n");
                nn::os::SignalEvent(&app.cancelEvent);
            }
        }
        else if (app.state == ApplicationState_Disconnected)
        {
            app.state = ApplicationState_Initialized;
            nn::os::WaitThread(&ldnThread);
            nn::os::DestroyThread(&ldnThread);
            nn::os::FinalizeMutex(&app.mutex);
            nn::os::FinalizeEvent(&app.cancelEvent);
        }

}
*/
