﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ldn.h>
#include "Types.h"

// ローカル通信識別子です。必ず任天堂から割り当てられた識別子を使用します。
const nn::Bit64 LocalCommunicationId = UINT64_C(0x0005000c10000000);

// デモ用のシーン識別子です。アプリケーションが用途に応じて自由に定義し、使い分けることができます。
const nn::Bit16 BasicSampleSceneId[5] = {
    UINT16_C(1), UINT16_C(2), UINT16_C(3), UINT16_C(4), UINT16_C(5)
};

// 通信の保護に使用するパスフレーズです。予想しにくい 16 バイト以上のデータを指定します。
const nn::Bit8 Passphrase[] = { 0x2F, 0x21, 0x8F, 0xA5, 0x24, 0x92, 0xD6, 0xF4,
                                0xA8, 0x52, 0x92, 0xED, 0x16, 0x53, 0x90, 0x5C };

// データの送受信に使用する UDP ポートです。
const int UdpPort = 12345;

const int FrameRate  = 60;
