﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/ldn/detail/Utility/ldn_ReverseByteOrder.h>
#include <nnt.h>

namespace
{

} // namespace <unnamed>

TEST(ReverseByteOrder, Int8)
{
    int8_t src = INT8_C(0x5A);
    int8_t expected = src;
    int8_t actual = nn::ldn::detail::ReverseByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ReverseByteOrder, UnsignedInt8)
{
    uint8_t src = UINT8_C(0x5A);
    uint8_t expected = src;
    uint8_t actual = nn::ldn::detail::ReverseByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ReverseByteOrder, Int16)
{
    int16_t src = INT16_C(0x1234);
    int16_t expected = INT16_C(0x3412);
    int16_t actual = nn::ldn::detail::ReverseByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ReverseByteOrder, UnsignedInt16)
{
    uint16_t src = UINT16_C(0x1234);
    uint16_t expected = UINT16_C(0x3412);
    uint16_t actual = nn::ldn::detail::ReverseByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ReverseByteOrder, Int32)
{
    int32_t src = INT32_C(0x12345678);
    int32_t expected = INT32_C(0x78563412);
    int32_t actual = nn::ldn::detail::ReverseByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ReverseByteOrder, UnsignedInt32)
{
    uint32_t src = UINT32_C(0x12345678);
    uint32_t expected = UINT32_C(0x78563412);
    uint32_t actual = nn::ldn::detail::ReverseByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ReverseByteOrder, Int64)
{
    int64_t src = INT64_C(0x0123456789ABCDEF);
    int64_t expected = INT64_C(0xEFCDAB8967452301);
    int64_t actual = nn::ldn::detail::ReverseByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ReverseByteOrder, UnsignedInt64)
{
    uint64_t src = UINT64_C(0x0123456789ABCDEF);
    uint64_t expected = UINT64_C(0xEFCDAB8967452301);
    uint64_t actual = nn::ldn::detail::ReverseByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ConvertToNetworkByteOrder, Int8)
{
    int8_t src = INT8_C(0x5A);
    int8_t expected = src;
    int8_t actual = nn::ldn::detail::ConvertToNetworkByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ConvertToNetworkByteOrder, UnsignedInt8)
{
    uint8_t src = UINT8_C(0x5A);
    uint8_t expected = src;
    uint8_t actual = nn::ldn::detail::ConvertToNetworkByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ConvertToNetworkByteOrder, Int16)
{
    int16_t src = INT16_C(0x1234);
    #if defined(NN_BUILD_CONFIG_ENDIAN_LITTLE)
    int16_t expected = INT16_C(0x3412);
    #elif defined(NN_BUILD_CONFIG_ENDIAN_BIG)
    int16_t expected = INT16_C(0x1234);
    #endif
    int16_t actual = nn::ldn::detail::ConvertToNetworkByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ConvertToNetworkByteOrder, UnsignedInt16)
{
    uint16_t src = UINT16_C(0x1234);
    #if defined(NN_BUILD_CONFIG_ENDIAN_LITTLE)
    uint16_t expected = UINT16_C(0x3412);
    #elif defined(NN_BUILD_CONFIG_ENDIAN_BIG)
    uint16_t expected = UINT16_C(0x1234);
    #endif
    uint16_t actual = nn::ldn::detail::ConvertToNetworkByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ConvertToNetworkByteOrder, Int32)
{
    int32_t src = INT32_C(0x12345678);
    #if defined(NN_BUILD_CONFIG_ENDIAN_LITTLE)
    int32_t expected = INT32_C(0x78563412);
    #elif defined(NN_BUILD_CONFIG_ENDIAN_BIG)
    int32_t expected = INT32_C(0x12345678);
    #endif
    int32_t actual = nn::ldn::detail::ConvertToNetworkByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ConvertToNetworkByteOrder, UnsignedInt32)
{
    uint32_t src = UINT32_C(0x12345678);
    #if defined(NN_BUILD_CONFIG_ENDIAN_LITTLE)
    uint32_t expected = UINT32_C(0x78563412);
    #elif defined(NN_BUILD_CONFIG_ENDIAN_BIG)
    uint32_t expected = UINT32_C(0x12345678);
    #endif
    uint32_t actual = nn::ldn::detail::ConvertToNetworkByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ConvertToNetworkByteOrder, Int64)
{
    int64_t src = INT64_C(0x0123456789ABCDEF);
    #if defined(NN_BUILD_CONFIG_ENDIAN_LITTLE)
    int64_t expected = INT64_C(0xEFCDAB8967452301);
    #elif defined(NN_BUILD_CONFIG_ENDIAN_BIG)
    int64_t expected = INT64_C(0x0123456789ABCDEF);
    #endif
    int64_t actual = nn::ldn::detail::ConvertToNetworkByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ConvertToNetworkByteOrder, UnsignedInt64)
{
    uint64_t src = UINT64_C(0x0123456789ABCDEF);
    #if defined(NN_BUILD_CONFIG_ENDIAN_LITTLE)
    uint64_t expected = UINT64_C(0xEFCDAB8967452301);
    #elif defined(NN_BUILD_CONFIG_ENDIAN_BIG)
    uint64_t expected = UINT64_C(0x0123456789ABCDEF);
    #endif
    uint64_t actual = nn::ldn::detail::ConvertToNetworkByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ConvertToHostByteOrder, Int8)
{
    int8_t src = INT8_C(0x5A);
    int8_t expected = src;
    int8_t actual = nn::ldn::detail::ConvertToHostByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ConvertToHostByteOrder, UnsignedInt8)
{
    uint8_t src = UINT8_C(0x5A);
    uint8_t expected = src;
    uint8_t actual = nn::ldn::detail::ConvertToHostByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ConvertToHostByteOrder, Int16)
{
    int16_t src = INT16_C(0x1234);
    #if defined(NN_BUILD_CONFIG_ENDIAN_LITTLE)
    int16_t expected = INT16_C(0x3412);
    #elif defined(NN_BUILD_CONFIG_ENDIAN_BIG)
    int16_t expected = INT16_C(0x1234);
    #endif
    int16_t actual = nn::ldn::detail::ConvertToHostByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ConvertToHostByteOrder, UnsignedInt16)
{
    uint16_t src = UINT16_C(0x1234);
    #if defined(NN_BUILD_CONFIG_ENDIAN_LITTLE)
    uint16_t expected = UINT16_C(0x3412);
    #elif defined(NN_BUILD_CONFIG_ENDIAN_BIG)
    uint16_t expected = UINT16_C(0x1234);
    #endif
    uint16_t actual = nn::ldn::detail::ConvertToHostByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ConvertToHostByteOrder, Int32)
{
    int32_t src = INT32_C(0x12345678);
    #if defined(NN_BUILD_CONFIG_ENDIAN_LITTLE)
    int32_t expected = INT32_C(0x78563412);
    #elif defined(NN_BUILD_CONFIG_ENDIAN_BIG)
    int32_t expected = INT32_C(0x12345678);
    #endif
    int32_t actual = nn::ldn::detail::ConvertToHostByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ConvertToHostByteOrder, UnsignedInt32)
{
    uint32_t src = UINT32_C(0x12345678);
    #if defined(NN_BUILD_CONFIG_ENDIAN_LITTLE)
    uint32_t expected = UINT32_C(0x78563412);
    #elif defined(NN_BUILD_CONFIG_ENDIAN_BIG)
    uint32_t expected = UINT32_C(0x12345678);
    #endif
    uint32_t actual = nn::ldn::detail::ConvertToHostByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ConvertToHostByteOrder, Int64)
{
    int64_t src = INT64_C(0x0123456789ABCDEF);
    #if defined(NN_BUILD_CONFIG_ENDIAN_LITTLE)
    int64_t expected = INT64_C(0xEFCDAB8967452301);
    #elif defined(NN_BUILD_CONFIG_ENDIAN_BIG)
    int64_t expected = INT64_C(0x0123456789ABCDEF);
    #endif
    int64_t actual = nn::ldn::detail::ConvertToHostByteOrder(src);
    ASSERT_EQ(expected, actual);
}

TEST(ConvertToHostByteOrder, UnsignedInt64)
{
    uint64_t src = UINT64_C(0x0123456789ABCDEF);
    #if defined(NN_BUILD_CONFIG_ENDIAN_LITTLE)
    uint64_t expected = UINT64_C(0xEFCDAB8967452301);
    #elif defined(NN_BUILD_CONFIG_ENDIAN_BIG)
    uint64_t expected = UINT64_C(0x0123456789ABCDEF);
    #endif
    uint64_t actual = nn::ldn::detail::ConvertToHostByteOrder(src);
    ASSERT_EQ(expected, actual);
}
