﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/ldn/detail/Utility/ldn_Math.h>
#include <nnt.h>

namespace
{

} // namespace <unnamed>

TEST(Clamp, MinimumValueMinusOne)
{
    int min = 100;
    int max = 200;
    int src = min - 1;
    int expected = min;
    int actual = nn::ldn::detail::Clamp(src, min, max);
    ASSERT_EQ(expected, actual);
}

TEST(Clamp, MaximumValuePlusOne)
{
    int min = 100;
    int max = 200;
    int src = max + 1;
    int expected = max;
    int actual = nn::ldn::detail::Clamp(src, min, max);
    ASSERT_EQ(expected, actual);
}

TEST(Clamp, MinimumValue)
{
    int min = 100;
    int max = 200;
    int src = min;
    int expected = min;
    int actual = nn::ldn::detail::Clamp(src, min, max);
    ASSERT_EQ(expected, actual);
}

TEST(Clamp, MaximumValue)
{
    int min = 100;
    int max = 200;
    int src = max;
    int expected = max;
    int actual = nn::ldn::detail::Clamp(src, min, max);
    ASSERT_EQ(expected, actual);
}

TEST(Clamp, MinimumValuePlusOne)
{
    int min = 100;
    int max = 200;
    int src = min + 1;
    int expected = src;
    int actual = nn::ldn::detail::Clamp(src, min, max);
    ASSERT_EQ(expected, actual);
}

TEST(Clamp, MaximumValueMinusOne)
{
    int min = 100;
    int max = 200;
    int src = max - 1;
    int expected = src;
    int actual = nn::ldn::detail::Clamp(src, min, max);
    ASSERT_EQ(expected, actual);
}
