﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_TimeSpan.h>
#include <nn/ldn.h>

// ローカル通信識別子です。
const auto LocalId = UINT64_C(0x0005000c10000000);

//! テストで使用するパスフレーズです。
const nn::Bit8 Passphrase[] = { 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77,
                                0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF };

//! アクセスポイントのユーザ名です。
const char ApUserName[] = "NetTestAp";

//! ステーションのユーザ名です。
const char StaUserName[] = "NetTestSta";

//! 接続待ちのタイムアウト時間です。
const nn::TimeSpan ConnectionTimeout = nn::TimeSpan::FromSeconds(5);

//! スキャン待ちのタイムアウト時間です。
const nn::TimeSpan ScanTimeout = nn::TimeSpan::FromSeconds(2);

//! ネットワーク破棄の待機時間です。
const nn::TimeSpan DestroyNetworkTimeout = nn::TimeSpan::FromSeconds(2);

//! ステーションの自発的切断の待機時間です。
const nn::TimeSpan DisconnectTimeout = nn::TimeSpan::FromSeconds(2);

//! アクセスポイントによるステーション切断の待機時間です。
const nn::TimeSpan RejectTimeout = nn::TimeSpan::FromSeconds(2);

//! 現在の状態をアドバータイズによってステーションに通知するための待機時間です。
const nn::TimeSpan AdvertisingTime = nn::TimeSpan::FromSeconds(1);

//! 無線スイッチが反映されるまでの待ち時間です。
const nn::TimeSpan FlightModeSwitchingTime = nn::TimeSpan::FromSeconds(1);
