﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

/**
 * @brief       指定された範囲 [min, max] の疑似乱数を生成します。
 * @param[in]   min         最小値です。
 * @param[in]   max         最大値です。
 * @return      [min, max] の範囲の疑似乱数です。
 */
int Random(int min, int max) NN_NOEXCEPT;

/**
 * @brief       疑似乱数のシードを設定します。
 * @param[in]   seed        設定するシードです。
 */
void SetSeed(int seed) NN_NOEXCEPT;
