﻿# コマンドラインツールのパスを設定します。
$CommandLineTools = "$SIGLO_ROOT\Tools\CommandLineTools"
if ($CONTROL_TARGET -eq $NULL)
{
    Set-Variable CONTROL_TARGET `
        "$CommandLineTools\ControlTarget.exe" `
        -Option Constant -Scope Script
}
if ($CONTROL_TARGET_PRIVATE -eq $NULL)
{
    Set-Variable CONTROL_TARGET_PRIVATE `
        "$CommandLineTools\ControlTargetPrivate.exe" `
        -Option Constant -Scope Script
}

# ControlTarget でコマンドを実行します。
Function ControlTarget()
{
    # ControlTarget は ControlTargetPrivate で代替可能です。
    $Tool = $NULL
    if (Test-Path $CONTROL_TARGET_PRIVATE)
    {
        $Tool = $CONTROL_TARGET_PRIVATE
    }
    elseif (Test-Path $CONTROL_TARGET)
    {
        $Tool = $CONTROL_TARGET
    }
    else
    {
        throw 'ControlTarget あるいは ControlTargetPrivate が見つかりません。'
    }

    # 指定されたコマンドを実行します。
    Write-Host "ControlTarget $Args"
    $Result = &$Tool $Args 2>&1

    # 標準出力もしくは標準エラー出力に [ERROR] が含まれていた場合は失敗扱いにします。
    if ($Result -match "^\[ERROR\]")
    {
        $Result | Write-Host

        # SIGLO-70370 の調査のために接続状態を出力します
        &netstat -b -a -o -n | Write-Host

        # TODO: SIGLO-78133 前後で流れが変わらないようにしておきます。
        # &netstat ~ の削除と同時にコメントアウトを外します。
        # throw $Result
    }
    return $Result
}


# ControlTargetPrivate でコマンドを実行します。
Function ControlTargetPrivate()
{
    # ControlTargetPrivate は ControlTarget で代替できません。
    if (!(Test-Path $CONTROL_TARGET_PRIVATE))
    {
        throw 'ControlTargetPrivate が見つかりません。'
    }

    # 指定されたコマンドを実行します。
    Write-Host "ControlTarget $Args"
    $Result = &$CONTROL_TARGET_PRIVATE $Args 2>&1
    
    # 標準出力もしくは標準エラー出力に [ERROR] が含まれていた場合は失敗扱いにします。
    if ($Result -match "^\[ERROR\]")
    {
        $Result | Write-Host

        # SIGLO-70370 の調査のために接続状態を出力します
        &netstat -b -a -o -n | Write-Host

        # TODO: SIGLO-78133 前後で流れが変わらないようにしておきます。
        # &netstat ~ の削除と同時にコメントアウトを外します。
        # throw $Result
    }
    return $Result
}

# PC に接続されている開発機の一覧を取得します。
Function GetTargetList()
{
    $Targets = ((ControlTarget list-target) -split "`n") | %{
        $Data = (-split $_)
        @{ Name = $Data[0]; Address = $Data[1]; }
    } | sort { [Version]$_.Address }
    $Targets = @($Targets)
    for ($i = 0; $i -lt $Targets.Length; ++$i)
    {
        $Targets[$i].Index = $i
    }
    return $Targets
}

# 開発機を再起動します。
Function ResetTarget($Target)
{
    ControlTarget reset -t $Target
    Start-Sleep -s 2
}

# 開発機に接続します。
Function ConnectToTarget($Target)
{
    ControlTarget connect -t $Target
    Start-Sleep -s 5
}
